/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.legacy.commands.InterruptLongPollCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Codec;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.server.legacy.ServerModelStore;
import com.canoo.dp.impl.server.legacy.action.CreatePresentationModelAction;
import com.canoo.dp.impl.server.legacy.action.DeletePresentationModelAction;
import com.canoo.dp.impl.server.legacy.action.DolphinServerAction;
import com.canoo.dp.impl.server.legacy.action.StoreAttributeAction;
import com.canoo.dp.impl.server.legacy.action.StoreValueChangeAction;
import com.canoo.dp.impl.server.legacy.communication.ActionRegistry;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConnector.class);
    private final ActionRegistry registry = new ActionRegistry();
    private final List<DolphinServerAction> dolphinServerActions = new ArrayList<DolphinServerAction>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    @Deprecated
    private Codec codec;
    private ServerModelStore serverModelStore;

    public List<Command> receive(Command command) {
        List<CommandHandler> actions;
        Assert.requireNonNull((Object)command, (String)"command");
        LOG.trace("Received command of type {}", (Object)command.getClass().getSimpleName());
        LinkedList<Command> response = new LinkedList<Command>();
        if (!(command instanceof InterruptLongPollCommand)) {
            for (DolphinServerAction it : this.dolphinServerActions) {
                it.setDolphinResponse(response);
            }
            this.serverModelStore.setCurrentResponse(response);
        }
        if ((actions = this.registry.getActionsFor(command.getClass())).isEmpty()) {
            LOG.warn("There is no server action registered for received command type {}, known commands types are {}", (Object)command.getClass().getSimpleName(), this.registry.getActions().keySet());
            return response;
        }
        ArrayList<CommandHandler> actionsCopy = new ArrayList<CommandHandler>();
        actionsCopy.addAll(actions);
        for (CommandHandler action : actionsCopy) {
            action.handleCommand(command, response);
        }
        return response;
    }

    public void register(DolphinServerAction action) {
        action.setServerModelStore(this.serverModelStore);
        this.dolphinServerActions.add(action);
        action.registerIn(this.registry);
    }

    public void registerDefaultActions() {
        if (this.initialized.getAndSet(true)) {
            LOG.warn("Attempt to initialize default actions more than once!");
            return;
        }
        this.register(new StoreValueChangeAction());
        this.register(new StoreAttributeAction());
        this.register(new CreatePresentationModelAction());
        this.register(new DeletePresentationModelAction());
    }

    @Deprecated
    public Codec getCodec() {
        return this.codec;
    }

    @Deprecated
    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public void setServerModelStore(ServerModelStore serverModelStore) {
        this.serverModelStore = serverModelStore;
    }

    public ActionRegistry getRegistry() {
        return this.registry;
    }

    @Deprecated
    public int getRegistrationCount() {
        return this.dolphinServerActions.size();
    }
}

