/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.remoting.legacy.communication.CreatePresentationModelCommand;
import com.canoo.dp.impl.remoting.legacy.communication.DeletePresentationModelCommand;
import com.canoo.dp.impl.remoting.legacy.communication.ValueChangedCommand;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreConfig;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.dp.impl.server.legacy.DTO;
import com.canoo.dp.impl.server.legacy.ServerAttribute;
import com.canoo.dp.impl.server.legacy.ServerPresentationModel;
import com.canoo.dp.impl.server.legacy.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ServerModelStore
extends ModelStore<ServerAttribute, ServerPresentationModel> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerModelStore.class);
    private static final AtomicInteger storeCount = new AtomicInteger(0);
    public final int id = storeCount.getAndIncrement();
    protected List<Command> currentResponse = null;
    protected long pmInstanceCount = 0L;

    public ServerModelStore() {
    }

    public ServerModelStore(ModelStoreConfig config) {
        super(config);
    }

    protected List<Command> getCurrentResponse() {
        return this.currentResponse;
    }

    public boolean hasResponseCommands() {
        return this.currentResponse != null && !this.currentResponse.isEmpty();
    }

    public void setCurrentResponse(List<Command> currentResponse) {
        this.currentResponse = currentResponse;
    }

    public boolean add(ServerPresentationModel model) {
        boolean added = super.add((PresentationModel)model);
        if (!added) {
            throw new IllegalStateException("Model " + (Object)((Object)model) + " already defined on server!");
        }
        model.setModelStore(this);
        this.getCurrentResponse().add((Command)CreatePresentationModelCommand.makeFrom((PresentationModel)model));
        return true;
    }

    public boolean checkClientAdded(ServerPresentationModel model) {
        boolean added = super.add((PresentationModel)model);
        model.setModelStore(this);
        return true;
    }

    public int getId() {
        return this.id;
    }

    public boolean remove(ServerPresentationModel pm) {
        boolean deleted = super.remove((PresentationModel)pm);
        if (!deleted) {
            throw new IllegalStateException("Model " + (Object)((Object)pm) + " not found on the server!");
        }
        ServerModelStore.deleteCommand(this.getCurrentResponse(), pm.getId());
        return deleted;
    }

    public boolean checkClientRemoved(ServerPresentationModel pm) {
        boolean deleted = super.remove((PresentationModel)pm);
        return deleted;
    }

    @Deprecated
    public static void deleteCommand(List<Command> response, String pmId) {
        if (response == null || Assert.isBlank((String)pmId)) {
            return;
        }
        response.add((Command)new DeletePresentationModelCommand(pmId));
    }

    @Deprecated
    public static void changeValueCommand(List<Command> response, ServerAttribute attribute, Object value) {
        if (response == null) {
            return;
        }
        if (attribute == null) {
            LOG.error("Cannot change value on a null attribute to '{}'", value);
            return;
        }
        ServerModelStore.forceChangeValue(value, response, attribute);
    }

    @Deprecated
    public static void forceChangeValue(Object value, List<Command> response, ServerAttribute attribute) {
        response.add((Command)new ValueChangedCommand(attribute.getId(), value));
    }

    @Deprecated
    public static void presentationModelCommand(List<Command> response, String id, String presentationModelType, DTO dto) {
        if (response == null) {
            return;
        }
        ArrayList list = new ArrayList();
        for (Slot slot : dto.getSlots()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("propertyName", slot.getPropertyName());
            map.put("value", slot.getValue());
            map.put("qualifier", slot.getQualifier());
            list.add(map);
        }
        response.add((Command)new CreatePresentationModelCommand(id, presentationModelType, list));
    }

    public ServerPresentationModel presentationModel(String id, String presentationModelType, DTO dto) {
        ArrayList<ServerAttribute> attributes = new ArrayList<ServerAttribute>();
        for (final Slot slot : dto.getSlots()) {
            final ServerAttribute result = new ServerAttribute(slot.getPropertyName(), slot.getValue(), slot.getQualifier());
            result.silently(new Runnable(){

                @Override
                public void run() {
                    result.setValue(slot.getValue());
                }
            });
            attributes.add(result);
        }
        ServerPresentationModel model = new ServerPresentationModel(id, attributes, this);
        model.setPresentationModelType(presentationModelType);
        this.add(model);
        return model;
    }
}

