/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy.action;

import com.canoo.dp.impl.remoting.legacy.communication.CreatePresentationModelCommand;
import com.canoo.dp.impl.server.legacy.ServerAttribute;
import com.canoo.dp.impl.server.legacy.ServerModelStore;
import com.canoo.dp.impl.server.legacy.ServerPresentationModel;
import com.canoo.dp.impl.server.legacy.action.DolphinServerAction;
import com.canoo.dp.impl.server.legacy.communication.ActionRegistry;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class CreatePresentationModelAction
extends DolphinServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePresentationModelAction.class);

    @Override
    public void registerIn(ActionRegistry registry) {
        registry.register(CreatePresentationModelCommand.class, new CommandHandler<CreatePresentationModelCommand>(){

            @Override
            public void handleCommand(CreatePresentationModelCommand command, List response) {
                CreatePresentationModelAction.createPresentationModel(command, CreatePresentationModelAction.this.getServerModelStore());
            }
        });
    }

    private static void createPresentationModel(CreatePresentationModelCommand command, ServerModelStore serverModelStore) {
        if (serverModelStore.findPresentationModelById(command.getPmId()) != null) {
            LOG.trace("Ignoring create PM '{}' since it is already in the model store.", (Object)command.getPmId());
            return;
        }
        if (command.getPmId().endsWith("-AUTO-SRV")) {
            LOG.trace("Creating the PM '{}' with reserved server-auto-suffix.", (Object)command.getPmId());
        }
        LinkedList<ServerAttribute> attributes = new LinkedList<ServerAttribute>();
        for (Map attr : command.getAttributes()) {
            ServerAttribute attribute = new ServerAttribute((String)attr.get("propertyName"), attr.get("value"), (String)attr.get("qualifier"));
            attribute.setId((String)attr.get("id"));
            attributes.add(attribute);
        }
        ServerPresentationModel model = new ServerPresentationModel(command.getPmId(), attributes, serverModelStore);
        model.setPresentationModelType(command.getPmType());
        serverModelStore.checkClientAdded(model);
    }
}

