/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy.action;

import com.canoo.dp.impl.remoting.legacy.communication.ChangeAttributeMetadataCommand;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.server.legacy.ServerAttribute;
import com.canoo.dp.impl.server.legacy.action.DolphinServerAction;
import com.canoo.dp.impl.server.legacy.communication.ActionRegistry;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class StoreAttributeAction
extends DolphinServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(StoreAttributeAction.class);

    @Override
    public void registerIn(ActionRegistry registry) {
        registry.register(ChangeAttributeMetadataCommand.class, new CommandHandler<ChangeAttributeMetadataCommand>(){

            @Override
            public void handleCommand(final ChangeAttributeMetadataCommand command, List response) {
                final Attribute attribute = StoreAttributeAction.this.getServerModelStore().findAttributeById(command.getAttributeId());
                if (attribute == null) {
                    LOG.warn("Cannot find attribute with id '{}'. Metadata remains unchanged.", (Object)command.getAttributeId());
                    return;
                }
                ((ServerAttribute)attribute).silently(new Runnable(){

                    @Override
                    public void run() {
                        if (command.getMetadataName().equals("value")) {
                            attribute.setValue(command.getValue());
                        } else if (command.getMetadataName().equals("qualifier")) {
                            if (command.getValue() == null) {
                                ((ServerAttribute)attribute).setQualifier(null);
                            } else {
                                ((ServerAttribute)attribute).setQualifier(command.getValue().toString());
                            }
                        } else {
                            throw new RuntimeException("Metadata type wrong!");
                        }
                    }
                });
            }
        });
    }
}

