/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy.action;

import com.canoo.dp.impl.remoting.legacy.communication.ValueChangedCommand;
import com.canoo.dp.impl.server.legacy.ServerAttribute;
import com.canoo.dp.impl.server.legacy.action.DolphinServerAction;
import com.canoo.dp.impl.server.legacy.communication.ActionRegistry;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class StoreValueChangeAction
extends DolphinServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(StoreValueChangeAction.class);

    @Override
    public void registerIn(ActionRegistry registry) {
        registry.register(ValueChangedCommand.class, new CommandHandler<ValueChangedCommand>(){

            @Override
            public void handleCommand(final ValueChangedCommand command, List response) {
                final ServerAttribute attribute = (ServerAttribute)StoreValueChangeAction.this.getServerModelStore().findAttributeById(command.getAttributeId());
                if (attribute != null) {
                    attribute.silently(new Runnable(){

                        @Override
                        public void run() {
                            attribute.setValue(command.getNewValue());
                        }
                    });
                } else {
                    LOG.error("S: cannot find attribute with id '{}' to change value from to '{}'.", (Object)command.getAttributeId(), command.getNewValue());
                }
            }
        });
    }
}

