/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.legacy.communication;

import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ActionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ActionRegistry.class);
    private final Map<Class<? extends Command>, List<CommandHandler>> actions = new HashMap<Class<? extends Command>, List<CommandHandler>>();

    public Map<Class<? extends Command>, List<CommandHandler>> getActions() {
        return Collections.unmodifiableMap(this.actions);
    }

    public void register(Class commandClass, CommandHandler serverCommand) {
        Objects.requireNonNull(commandClass);
        Objects.requireNonNull(serverCommand);
        LOG.trace("Register handler for command type " + commandClass.getSimpleName());
        List<CommandHandler> actions = this.getActionsFor(commandClass);
        if (!actions.contains(serverCommand)) {
            actions.add(serverCommand);
        }
    }

    public List<CommandHandler> getActionsFor(Class<? extends Command> commandClass) {
        List<CommandHandler> actions = this.actions.get(commandClass);
        if (actions == null) {
            actions = new ArrayList<CommandHandler>();
            this.actions.put(commandClass, actions);
        }
        return actions;
    }
}

