/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.mbean;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.gc.GarbageCollector;
import com.canoo.dp.impl.server.mbean.MBeanDescription;
import com.canoo.dp.impl.server.mbean.MBeanRegistry;
import com.canoo.dp.impl.server.mbean.beans.DolphinControllerInfo;
import com.canoo.dp.impl.server.mbean.beans.DolphinSessionInfo;
import com.canoo.dp.impl.server.mbean.beans.ModelProvider;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.server.client.ClientSession;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinContextMBeanRegistry {
    private final String dolphinContextId;

    public DolphinContextMBeanRegistry(String dolphinContextId) {
        this.dolphinContextId = (String)Assert.requireNonNull((Object)dolphinContextId, (String)"dolphinContextId");
    }

    public Subscription registerDolphinContext(ClientSession session, GarbageCollector garbageCollector) {
        Assert.requireNonNull((Object)session, (String)"session");
        Assert.requireNonNull((Object)garbageCollector, (String)"garbageCollector");
        DolphinSessionInfo mBean = new DolphinSessionInfo(session, garbageCollector);
        return MBeanRegistry.getInstance().register((Object)mBean, new MBeanDescription("com.canoo.dolphin", "DolphinSession", "session"));
    }

    public Subscription registerController(Class<?> controllerClass, String controllerId, ModelProvider modelProvider) {
        Assert.requireNonNull(controllerClass, (String)"controllerClass");
        Assert.requireNonBlank((String)controllerId, (String)"controllerId");
        Assert.requireNonNull((Object)modelProvider, (String)"modelProvider");
        DolphinControllerInfo mBean = new DolphinControllerInfo(this.dolphinContextId, controllerClass, controllerId, modelProvider);
        return MBeanRegistry.getInstance().register((Object)mBean, new MBeanDescription("com.canoo.dolphin", controllerClass.getSimpleName(), "controller"));
    }
}

