/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.mbean.beans;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.gc.GarbageCollector;
import com.canoo.dp.impl.server.mbean.beans.DolphinSessionInfoMBean;
import com.canoo.platform.server.client.ClientSession;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinSessionInfo
implements DolphinSessionInfoMBean {
    private final WeakReference<ClientSession> dolphinSessionRef;
    private final WeakReference<GarbageCollector> garbageCollectionRef;

    public DolphinSessionInfo(ClientSession dolphinSession, GarbageCollector garbageCollector) {
        this.dolphinSessionRef = new WeakReference<ClientSession>(dolphinSession);
        this.garbageCollectionRef = new WeakReference<GarbageCollector>(garbageCollector);
    }

    private ClientSession getSession() {
        ClientSession session = (ClientSession)this.dolphinSessionRef.get();
        Assert.requireNonNull((Object)session, (String)"session");
        return session;
    }

    private GarbageCollector getGarbageCollection() {
        GarbageCollector garbageCollector = (GarbageCollector)this.garbageCollectionRef.get();
        Assert.requireNonNull((Object)garbageCollector, (String)"garbageCollector");
        return garbageCollector;
    }

    @Override
    public String getDolphinSessionId() {
        return this.getSession().getId();
    }

    @Override
    public Set<String> getAttributesNames() {
        return this.getSession().getAttributeNames();
    }

    @Override
    public Object getAttribute(String name) {
        return this.getSession().getAttribute(name);
    }

    @Override
    public long getGarbageCollectionRuns() {
        return this.getGarbageCollection().getGcCalls();
    }

    @Override
    public long getGarbageCollectionRemovedBeansTotal() {
        return this.getGarbageCollection().getRemovedBeansCount();
    }

    @Override
    public int getGarbageCollectionCurrentManagedBeansCount() {
        return this.getGarbageCollection().getManagedInstancesCount();
    }
}

