/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.mbean.beans;

import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ModelJsonSerializer {
    public static JsonObject toJson(Object dolphinModel) {
        if (dolphinModel == null) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        for (Field field : ReflectionHelper.getInheritedDeclaredFields(dolphinModel.getClass())) {
            if (DolphinUtils.isProperty(field.getType())) {
                Property property = (Property)ReflectionHelper.getPrivileged((Field)field, (Object)dolphinModel);
                Object value = property.get();
                if (value == null) {
                    jsonObject.add(field.getName(), null);
                    continue;
                }
                if (Number.class.isAssignableFrom(value.getClass()) || Double.TYPE.isAssignableFrom(value.getClass()) || Float.TYPE.isAssignableFrom(value.getClass()) || Long.TYPE.isAssignableFrom(value.getClass()) || Integer.TYPE.isAssignableFrom(value.getClass())) {
                    jsonObject.add(field.getName(), (JsonElement)new JsonPrimitive((Number)value));
                    continue;
                }
                if (String.class.isAssignableFrom(value.getClass())) {
                    jsonObject.add(field.getName(), (JsonElement)new JsonPrimitive((String)value));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass())) {
                    jsonObject.add(field.getName(), (JsonElement)new JsonPrimitive((Boolean)value));
                    continue;
                }
                jsonObject.add(field.getName(), (JsonElement)ModelJsonSerializer.toJson(value));
                continue;
            }
            if (!DolphinUtils.isObservableList(field.getType())) continue;
            ObservableList list = (ObservableList)ReflectionHelper.getPrivileged((Field)field, (Object)dolphinModel);
            JsonArray jsonArray = new JsonArray();
            for (Object value : list) {
                if (value == null) continue;
                if (Number.class.isAssignableFrom(value.getClass()) || Double.TYPE.isAssignableFrom(value.getClass()) || Float.TYPE.isAssignableFrom(value.getClass()) || Long.TYPE.isAssignableFrom(value.getClass()) || Integer.TYPE.isAssignableFrom(value.getClass())) {
                    jsonArray.add((JsonElement)new JsonPrimitive((Number)value));
                    continue;
                }
                if (String.class.isAssignableFrom(value.getClass())) {
                    jsonArray.add((JsonElement)new JsonPrimitive((String)value));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass())) {
                    jsonArray.add((JsonElement)new JsonPrimitive((Boolean)value));
                    continue;
                }
                jsonArray.add((JsonElement)ModelJsonSerializer.toJson(value));
            }
            jsonObject.add(field.getName(), (JsonElement)jsonArray);
        }
        return jsonObject;
    }
}

