/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.model;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.AbstractBeanBuilder;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.ClassRepository;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.ListMapper;
import com.canoo.dp.impl.remoting.PresentationModelBuilderFactory;
import com.canoo.dp.impl.remoting.PropertyImpl;
import com.canoo.dp.impl.remoting.collections.ObservableArrayList;
import com.canoo.dp.impl.remoting.info.PropertyInfo;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.dp.impl.server.gc.GarbageCollector;
import com.canoo.dp.impl.server.model.ServerBeanBuilder;
import com.canoo.platform.remoting.ListChangeEvent;
import com.canoo.platform.remoting.ListChangeListener;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.ValueChangeEvent;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ServerBeanBuilderImpl
extends AbstractBeanBuilder
implements ServerBeanBuilder {
    private final GarbageCollector garbageCollector;

    public ServerBeanBuilderImpl(ClassRepository classRepository, BeanRepository beanRepository, ListMapper listMapper, PresentationModelBuilderFactory builderFactory, EventDispatcher dispatcher, GarbageCollector garbageCollector) {
        super(classRepository, beanRepository, listMapper, builderFactory, dispatcher);
        this.garbageCollector = (GarbageCollector)Assert.requireNonNull((Object)garbageCollector, (String)"garbageCollector");
    }

    @Override
    public <T> T createRootModel(Class<T> beanClass) {
        Object bean = super.create(beanClass);
        this.garbageCollector.onBeanCreated(bean, true);
        return (T)bean;
    }

    public <T> T create(Class<T> beanClass) {
        Object bean = super.create(beanClass);
        this.garbageCollector.onBeanCreated(bean, false);
        return (T)bean;
    }

    protected <T> ObservableList<T> create(final PropertyInfo observableListInfo, final PresentationModel model, final ListMapper listMapper) {
        Assert.requireNonNull((Object)model, (String)"model");
        Assert.requireNonNull((Object)listMapper, (String)"listMapper");
        ObservableArrayList list = new ObservableArrayList<T>(){

            protected void notifyInternalListeners(ListChangeEvent<T> event) {
                listMapper.processEvent(observableListInfo, model.getId(), event);
            }
        };
        list.onChanged(new ListChangeListener<T>((ObservableList)list){
            final /* synthetic */ ObservableList val$list;
            {
                this.val$list = observableList;
            }

            public void listChanged(ListChangeEvent<? extends T> event) {
                for (ListChangeEvent.Change c : event.getChanges()) {
                    if (c.isAdded()) {
                        for (Object added : this.val$list.subList(c.getFrom(), c.getTo())) {
                            ServerBeanBuilderImpl.this.garbageCollector.onAddedToList(this.val$list, added);
                        }
                    }
                    if (c.isRemoved()) {
                        for (Object removed : c.getRemovedElements()) {
                            ServerBeanBuilderImpl.this.garbageCollector.onRemovedFromList(this.val$list, removed);
                        }
                    }
                    if (!c.isReplaced()) continue;
                }
            }
        });
        return list;
    }

    protected <T> Property<T> create(Attribute attribute, PropertyInfo propertyInfo) {
        return new PropertyImpl<T>(attribute, propertyInfo){

            protected void notifyInternalListeners(ValueChangeEvent event) {
                super.notifyInternalListeners(event);
                ServerBeanBuilderImpl.this.garbageCollector.onPropertyValueChanged(event.getSource(), event.getOldValue(), event.getNewValue());
            }
        };
    }
}

