/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.model;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.AbstractControllerActionCallBean;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.MappingException;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ServerControllerActionCallBean
extends AbstractControllerActionCallBean {
    private final Converters converters;
    private final PresentationModel pm;

    public ServerControllerActionCallBean(Converters converters, PresentationModel pm) {
        this.converters = (Converters)Assert.requireNonNull((Object)converters, (String)"converters");
        this.pm = (PresentationModel)Assert.requireNonNull((Object)pm, (String)"pm");
    }

    public String getControllerId() {
        return (String)this.pm.getAttribute("controllerId").getValue();
    }

    public String getActionName() {
        return (String)this.pm.getAttribute("actionName").getValue();
    }

    public void setError(boolean error) {
        this.pm.getAttribute("errorCode").setValue((Object)error);
    }

    public Object getParam(String name, Class<?> type) {
        String internalName = "_" + name;
        Attribute valueAttribute = this.pm.getAttribute(internalName);
        if (valueAttribute == null) {
            throw new IllegalArgumentException(String.format("Invoking RemotingAction requires parameter '%s', but it was not withContent", name));
        }
        try {
            return this.converters.getConverter(type).convertFromDolphin(valueAttribute.getValue());
        }
        catch (ValueConverterException e) {
            throw new MappingException("Error in conversion", (Throwable)e);
        }
    }
}

