/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.remoting.server.event;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.remoting.server.event.MessageEventContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpSessionEventFilter<T extends Serializable>
implements Predicate<MessageEventContext<T>> {
    private final List<String> sessionIds;

    public HttpSessionEventFilter(String ... sessionIds) {
        this.sessionIds = Arrays.asList(sessionIds);
    }

    @Override
    public boolean test(MessageEventContext<T> context) {
        Assert.requireNonNull(context, (String)"context");
        Map<String, Serializable> metadata = context.getMetadata();
        if (metadata == null) {
            return false;
        }
        Serializable httpSessionIdValue = metadata.get("sender.httpSessionId");
        return httpSessionIdValue != null && this.sessionIds.contains(httpSessionIdValue);
    }
}

