/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.spring;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.beans.PostConstructInterceptor;
import com.canoo.dp.impl.server.spring.SpringPreInjector;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import javax.servlet.ServletContext;
import org.apiguardian.api.API;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

@API(since="0.x", status=API.Status.INTERNAL)
public abstract class AbstractSpringManagedBeanFactory
implements ManagedBeanFactory {
    public void init(ServletContext servletContext) {
        this.init();
    }

    protected void init() {
        ApplicationContext context = this.getContext();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)SpringPreInjector.getInstance());
    }

    public <T> T createDependentInstance(Class<T> cls) {
        Assert.requireNonNull(cls, (String)"cls");
        ApplicationContext context = this.getContext();
        AutowireCapableBeanFactory beanFactory = context.getAutowireCapableBeanFactory();
        return (T)beanFactory.createBean(cls);
    }

    public <T> T createDependentInstance(Class<T> cls, PostConstructInterceptor<T> interceptor) {
        Assert.requireNonNull(cls, (String)"cls");
        Assert.requireNonNull(interceptor, (String)"interceptor");
        ApplicationContext context = this.getContext();
        AutowireCapableBeanFactory beanFactory = context.getAutowireCapableBeanFactory();
        SpringPreInjector.getInstance().prepare(cls, interceptor);
        return (T)beanFactory.createBean(cls);
    }

    public <T> void destroyDependentInstance(T instance, Class<T> cls) {
        Assert.requireNonNull(instance, (String)"instance");
        Assert.requireNonNull(cls, (String)"cls");
        ApplicationContext context = this.getContext();
        context.getAutowireCapableBeanFactory().destroyBean(instance);
    }

    protected abstract ApplicationContext getContext();
}

