/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.spring;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.bootstrap.PlatformBootstrap;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.platform.server.client.ClientSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientScopeImpl
implements Scope {
    public static final String CLIENT_SCOPE = "client";
    private static final String CLIENT_STORE_ATTRIBUTE = "DolphinPlatformSpringClientScopeStore";

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Assert.requireNonBlank((String)name, (String)"name");
        Assert.requireNonNull(objectFactory, (String)"objectFactory");
        Map<String, Object> localStore = this.getLocalStore();
        if (!localStore.containsKey(name)) {
            localStore.put(name, objectFactory.getObject());
        }
        return localStore.get(name);
    }

    public Object remove(String name) {
        return this.getLocalStore().remove(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    private Map<String, Object> getLocalStore() {
        ClientSession session = this.getClientSession();
        if (session == null) {
            throw new IllegalStateException("No dolphin request found! Looks like you try to use the " + ClientScopeImpl.class.getSimpleName() + " ouside of the dolphin context!");
        }
        Map localStore = (Map)session.getAttribute(CLIENT_STORE_ATTRIBUTE);
        if (localStore == null) {
            localStore = Collections.synchronizedMap(new HashMap());
            session.setAttribute(CLIENT_STORE_ATTRIBUTE, localStore);
        }
        return localStore;
    }

    public String getConversationId() {
        return this.getClientSession().getId();
    }

    protected ClientSession getClientSession() {
        ClientSessionProvider clientSessionProvider = (ClientSessionProvider)PlatformBootstrap.getServerCoreComponents().getInstance(ClientSessionProvider.class);
        Assert.requireNonNull((Object)clientSessionProvider, (String)"clientSessionProvider");
        return clientSessionProvider.getCurrentClientSession();
    }
}

