/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.spring;

import com.canoo.dp.impl.server.bootstrap.PlatformBootstrap;
import com.canoo.dp.impl.server.config.ConfigurationFileLoader;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinPlatformSpringBootstrap
implements ServletContextInitializer,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinPlatformSpringBootstrap.class);
    private static final String PREFIX = "dolphinPlatform.";
    @Autowired
    private Environment environment;
    @Autowired(required=false)
    private DefaultPlatformConfiguration injectedConfig;
    private static ApplicationContext ctx = null;

    public void onStartup(ServletContext servletContext) throws ServletException {
        DefaultPlatformConfiguration configuration = this.injectedConfig;
        if (configuration == null) {
            configuration = ConfigurationFileLoader.loadConfiguration();
        }
        this.updateConfigurationBySpring(configuration);
        PlatformBootstrap bootstrap = new PlatformBootstrap();
        bootstrap.init(servletContext, configuration);
    }

    private void updateConfigurationBySpring(DefaultPlatformConfiguration configuration) {
        for (String key : configuration.getPropertyKeys()) {
            String valInSpringConfig = this.environment.getProperty(PREFIX + key);
            if (valInSpringConfig == null) continue;
            LOG.debug("Dolphin Platform property '{}' found in spring configuration", (Object)key);
            configuration.setProperty(key, valInSpringConfig);
        }
    }

    public static ApplicationContext getApplicationContext() {
        return ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        DolphinPlatformSpringBootstrap.ctx = ctx;
    }
}

