/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.spring;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.bootstrap.PlatformBootstrap;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.servlet.ServerTimingFilter;
import com.canoo.dp.impl.server.spring.ClientScopeImpl;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.spring.ClientScope;
import com.canoo.platform.server.timing.ServerTiming;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apiguardian.api.API;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.annotation.RequestScope;

@Configuration
@API(since="0.x", status=API.Status.INTERNAL)
public class SpringBeanFactory {
    @Bean(name={"clientSession"})
    @ClientScope
    protected ClientSession createClientSession() {
        ClientSessionProvider provider = (ClientSessionProvider)PlatformBootstrap.getServerCoreComponents().getInstance(ClientSessionProvider.class);
        Assert.requireNonNull((Object)provider, (String)"provider");
        return provider.getCurrentClientSession();
    }

    @Bean(name={"customScopeConfigurer"})
    public static CustomScopeConfigurer createClientScope() {
        CustomScopeConfigurer configurer = new CustomScopeConfigurer();
        configurer.addScope("client", (Scope)new ClientScopeImpl());
        return configurer;
    }

    @Bean(name={"serverTiming"})
    @RequestScope
    protected ServerTiming createServerTiming() {
        return (ServerTiming)Proxy.newProxyInstance(SpringBeanFactory.class.getClassLoader(), new Class[]{ServerTiming.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)ServerTimingFilter.getCurrentTiming(), args);
            }
        });
    }
}

