/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.spring;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.beans.PostConstructInterceptor;
import org.apiguardian.api.API;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

@API(since="0.7", status=API.Status.INTERNAL)
public class SpringPreInjector
extends InstantiationAwareBeanPostProcessorAdapter {
    private final ThreadLocal<PostConstructInterceptor> currentInterceptor = new ThreadLocal();
    private final ThreadLocal<Class> currentControllerClass = new ThreadLocal();
    private static final SpringPreInjector instance = new SpringPreInjector();

    public void prepare(Class controllerClass, PostConstructInterceptor interceptor) {
        Assert.requireNonNull((Object)controllerClass, (String)"controllerClass");
        Assert.requireNonNull((Object)interceptor, (String)"interceptor");
        this.currentControllerClass.set(controllerClass);
        this.currentInterceptor.set(interceptor);
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        Assert.requireNonNull((Object)bean, (String)"bean");
        Class controllerClass = this.currentControllerClass.get();
        if (controllerClass != null && controllerClass.isAssignableFrom(bean.getClass())) {
            PostConstructInterceptor modelInjector = this.currentInterceptor.get();
            if (modelInjector != null) {
                modelInjector.intercept(bean);
            }
            this.currentControllerClass.set(null);
            this.currentInterceptor.set(null);
        }
        return true;
    }

    public static SpringPreInjector getInstance() {
        return instance;
    }
}

