/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.bootstrap;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.SimpleDolphinPlatformThreadFactory;
import com.canoo.dp.impl.platform.core.ansi.PlatformLogo;
import com.canoo.dp.impl.server.bootstrap.ServerCoreComponentsImpl;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.dp.impl.server.mbean.MBeanRegistry;
import com.canoo.dp.impl.server.scanner.DefaultClasspathScanner;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.PlatformThreadFactory;
import com.canoo.platform.server.spi.ModuleDefinition;
import com.canoo.platform.server.spi.ModuleInitializationException;
import com.canoo.platform.server.spi.ServerCoreComponents;
import com.canoo.platform.server.spi.ServerModule;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class PlatformBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformBootstrap.class);
    private static final String CONFIGURATION_ATTRIBUTE_NAME = "dolphinPlatformConfiguration";
    private static ServerCoreComponents serverCoreComponents;

    public void init(ServletContext servletContext, DefaultPlatformConfiguration configuration) {
        Assert.requireNonNull((Object)servletContext, (String)"servletContext");
        Assert.requireNonNull((Object)configuration, (String)"configuration");
        if (configuration.getBooleanProperty("active", true)) {
            PlatformLogo.printLogo();
            try {
                LOG.info("Will boot Dolphin Plaform now");
                servletContext.setAttribute(CONFIGURATION_ATTRIBUTE_NAME, (Object)configuration);
                configuration.log();
                MBeanRegistry.getInstance().setMbeanSupport(configuration.getBooleanProperty("mBeanRegistration", false));
                SimpleDolphinPlatformThreadFactory threadFactory = new SimpleDolphinPlatformThreadFactory();
                ManagedBeanFactory beanFactory = this.getBeanFactory(servletContext);
                DefaultClasspathScanner classpathScanner = new DefaultClasspathScanner(configuration.getListProperty("rootPackageForClasspathScan"));
                serverCoreComponents = new ServerCoreComponentsImpl(servletContext, configuration, (PlatformThreadFactory)threadFactory, classpathScanner, beanFactory);
                Set<Class<?>> moduleClasses = classpathScanner.getTypesAnnotatedWith(ModuleDefinition.class);
                HashMap<String, ServerModule> modules = new HashMap<String, ServerModule>();
                for (Class<?> clazz : moduleClasses) {
                    if (!ServerModule.class.isAssignableFrom(clazz)) {
                        throw new DolphinRuntimeException("Class " + clazz + " is annoated with " + ModuleDefinition.class.getSimpleName() + " but do not implement " + ServerModule.class.getSimpleName());
                    }
                    ModuleDefinition moduleDefinition = clazz.getAnnotation(ModuleDefinition.class);
                    ServerModule instance = (ServerModule)clazz.newInstance();
                    modules.put(instance.getName(), instance);
                }
                LOG.info("Found {} Dolphin Plaform modules", (Object)modules.size());
                if (LOG.isTraceEnabled()) {
                    for (String string : modules.keySet()) {
                        LOG.trace("Found Dolphin Plaform module {}", (Object)string);
                    }
                }
                for (Map.Entry entry : modules.entrySet()) {
                    LOG.debug("Will initialize Dolphin Plaform module {}", entry.getKey());
                    ServerModule module = (ServerModule)entry.getValue();
                    if (!module.shouldBoot(serverCoreComponents.getConfiguration())) continue;
                    List<String> neededModules = module.getModuleDependencies();
                    for (String neededModule : neededModules) {
                        if (modules.containsKey(neededModule)) continue;
                        throw new ModuleInitializationException("Module " + (String)entry.getKey() + " depends on missing module " + neededModule);
                    }
                    module.initialize(serverCoreComponents);
                }
                LOG.info("Dolphin Plaform booted");
            }
            catch (Exception e) {
                throw new RuntimeException("Can not boot Dolphin Platform", e);
            }
        } else {
            LOG.info("Dolphin Plaform is deactivated");
        }
    }

    private ManagedBeanFactory getBeanFactory(ServletContext servletContext) {
        ServiceLoader<ManagedBeanFactory> serviceLoader = ServiceLoader.load(ManagedBeanFactory.class);
        Iterator<ManagedBeanFactory> serviceIterator = serviceLoader.iterator();
        if (serviceIterator.hasNext()) {
            ManagedBeanFactory factory = serviceIterator.next();
            if (serviceIterator.hasNext()) {
                throw new IllegalStateException("More than 1 " + ManagedBeanFactory.class + " found!");
            }
            LOG.debug("Container Manager of type {} is used", (Object)factory.getClass().getSimpleName());
            factory.init(servletContext);
            return factory;
        }
        throw new IllegalStateException("No " + ManagedBeanFactory.class + " found!");
    }

    public static ServerCoreComponents getServerCoreComponents() {
        return serverCoreComponents;
    }
}

