/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.bootstrap.modules;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.client.ClientSessionFilter;
import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandler;
import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandlerImpl;
import com.canoo.dp.impl.server.client.ClientSessionManager;
import com.canoo.dp.impl.server.client.ClientSessionMutextHolder;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.client.HttpSessionCleanerListener;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.platform.core.PlatformConfiguration;
import com.canoo.platform.server.ServerListener;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.client.ClientSessionListener;
import com.canoo.platform.server.spi.AbstractBaseModule;
import com.canoo.platform.server.spi.ModuleDefinition;
import com.canoo.platform.server.spi.ModuleInitializationException;
import com.canoo.platform.server.spi.ServerCoreComponents;
import com.canoo.platform.server.spi.components.ClasspathScanner;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
@ModuleDefinition
public class ClientSessionModule
extends AbstractBaseModule {
    public static final String CLIENT_SESSION_MODULE = "ClientSessionModule";
    public static final String CLIENT_SESSION_MODULE_ACTIVE = "clientSessionActive";
    public static final String DOLPHIN_CLIENT_ID_FILTER_NAME = "clientIdFilter";

    @Override
    protected String getActivePropertyName() {
        return CLIENT_SESSION_MODULE_ACTIVE;
    }

    @Override
    public String getName() {
        return CLIENT_SESSION_MODULE;
    }

    @Override
    public void initialize(ServerCoreComponents coreComponents) throws ModuleInitializationException {
        Assert.requireNonNull((Object)coreComponents, (String)"coreComponents");
        ServletContext servletContext = coreComponents.getInstance(ServletContext.class);
        PlatformConfiguration configuration = coreComponents.getConfiguration();
        ClasspathScanner classpathScanner = coreComponents.getInstance(ClasspathScanner.class);
        ManagedBeanFactory beanFactory = coreComponents.getInstance(ManagedBeanFactory.class);
        final ClientSessionLifecycleHandlerImpl lifecycleHandler = new ClientSessionLifecycleHandlerImpl();
        coreComponents.provideInstance(ClientSessionLifecycleHandler.class, lifecycleHandler);
        coreComponents.provideInstance(ClientSessionProvider.class, new ClientSessionProvider(){

            @Override
            public ClientSession getCurrentClientSession() {
                return lifecycleHandler.getCurrentDolphinSession();
            }
        });
        ClientSessionManager clientSessionManager = new ClientSessionManager(configuration, lifecycleHandler);
        List endpointList = configuration.getListProperty("idFilterUrlMappings", DefaultPlatformConfiguration.ID_FILTER_URL_MAPPINGS_DEFAULT_VALUE);
        String[] endpoints = endpointList.toArray(new String[endpointList.size()]);
        ClientSessionFilter filter = new ClientSessionFilter(clientSessionManager);
        FilterRegistration.Dynamic createdFilter = servletContext.addFilter(DOLPHIN_CLIENT_ID_FILTER_NAME, (Filter)filter);
        createdFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, endpoints);
        HttpSessionCleanerListener sessionCleaner = new HttpSessionCleanerListener(clientSessionManager);
        servletContext.addListener((EventListener)((Object)sessionCleaner));
        Set<Class<?>> listeners = classpathScanner.getTypesAnnotatedWith(ServerListener.class);
        for (Class<?> listenerClass : listeners) {
            if (!ClientSessionListener.class.isAssignableFrom(listenerClass)) continue;
            ClientSessionListener listener = (ClientSessionListener)beanFactory.createDependentInstance(listenerClass);
            lifecycleHandler.addSessionDestroyedListener(s -> listener.sessionDestroyed((ClientSession)s));
            lifecycleHandler.addSessionCreatedListener(s -> listener.sessionCreated((ClientSession)s));
        }
        ClientSessionMutextHolder mutextHolder = new ClientSessionMutextHolder();
        lifecycleHandler.addSessionDestroyedListener(s -> mutextHolder.sessionDestroyed((ClientSession)s));
        lifecycleHandler.addSessionCreatedListener(s -> mutextHolder.sessionCreated((ClientSession)s));
    }
}

