/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.bootstrap.modules;

import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.dp.impl.server.servlet.CrossSiteOriginFilter;
import com.canoo.platform.core.PlatformConfiguration;
import com.canoo.platform.server.spi.AbstractBaseModule;
import com.canoo.platform.server.spi.ModuleDefinition;
import com.canoo.platform.server.spi.ModuleInitializationException;
import com.canoo.platform.server.spi.ServerCoreComponents;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
@ModuleDefinition
public class CorsModule
extends AbstractBaseModule {
    public static final String CORS_MODULE = "CorsModule";
    public static final String CORS_FILTER = "CorsFilter";
    public static final String CORS_MODULE_ACTIVE = "corsActive";

    @Override
    protected String getActivePropertyName() {
        return CORS_MODULE_ACTIVE;
    }

    @Override
    public String getName() {
        return CORS_MODULE;
    }

    @Override
    public void initialize(ServerCoreComponents coreComponents) throws ModuleInitializationException {
        ServletContext servletContext = coreComponents.getInstance(ServletContext.class);
        PlatformConfiguration configuration = coreComponents.getConfiguration();
        List endpointList = configuration.getListProperty("corsUrlMappings", DefaultPlatformConfiguration.CORS_ENDPOINTS_URL_MAPPINGS_DEFAULT_VALUE);
        String[] endpoints = endpointList.toArray(new String[endpointList.size()]);
        CrossSiteOriginFilter filter = new CrossSiteOriginFilter(configuration);
        FilterRegistration.Dynamic createdFilter = servletContext.addFilter(CORS_FILTER, (Filter)filter);
        createdFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, endpoints);
    }
}

