/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.client.ClientSessionManager;
import com.canoo.dp.impl.server.client.MaxSessionCountReachedException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionFilter.class);
    private static final String INITIALIZED_IN_SESSION = "PD_INITIALIZED_IN_SESSION";
    private final ClientSessionManager clientSessionManager;

    public ClientSessionFilter(ClientSessionManager clientSessionManager) {
        this.clientSessionManager = (ClientSessionManager)Assert.requireNonNull((Object)clientSessionManager, (String)"clientSessionManager");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        HttpSession httpSession = (HttpSession)Assert.requireNonNull((Object)servletRequest.getSession(), (String)"request.getSession()");
        try {
            String clientId = servletRequest.getHeader("dolphin_platform_intern_dolphinClientId");
            if (clientId == null || clientId.trim().isEmpty()) {
                try {
                    String createdClientId = this.clientSessionManager.createClientSession(httpSession);
                    this.continueRequest(servletRequest, servletResponse, chain, httpSession, createdClientId);
                }
                catch (MaxSessionCountReachedException e) {
                    LOG.warn("Maximum size for clients in session {} is reached", (Object)servletRequest.getSession().getId());
                    servletResponse.sendError(503, "Maximum size for clients in session is reached");
                }
            } else {
                LOG.trace("Trying to find client session {} in http session {}", (Object)clientId, (Object)httpSession.getId());
                if (!this.clientSessionManager.checkValidClientSession(httpSession, clientId)) {
                    if (httpSession.getAttribute(INITIALIZED_IN_SESSION) == null) {
                        LOG.warn("Can not find requested client for id {} in session {} (session timeout)", (Object)clientId, (Object)httpSession.getId());
                        servletResponse.sendError(408, "Can not find requested client (session timeout)!");
                    } else {
                        LOG.warn("Can not find requested client for id {} in session {} (unknown error)", (Object)clientId, (Object)httpSession.getId());
                        servletResponse.sendError(500, "Can not find requested client (unknown error)!");
                    }
                } else {
                    this.continueRequest(servletRequest, servletResponse, chain, httpSession, clientId);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while checking requested client in session " + httpSession.getId() + " (unknown error)", (Throwable)e);
            servletResponse.sendError(500, "Can not find requested client (unknown error)!");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continueRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain, HttpSession httpSession, String clientSessionId) throws IOException, ServletException {
        this.clientSessionManager.setClientSessionForThread(httpSession, clientSessionId);
        try {
            Object init = httpSession.getAttribute(INITIALIZED_IN_SESSION);
            if (init == null) {
                httpSession.setAttribute(INITIALIZED_IN_SESSION, (Object)true);
            }
            response.setHeader("dolphin_platform_intern_dolphinClientId", clientSessionId);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.clientSessionManager.resetClientSessionForThread();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

