/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.client;

import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandler;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.server.client.ClientSession;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public final class ClientSessionLifecycleHandlerImpl
implements ClientSessionLifecycleHandler {
    private final List<Consumer<ClientSession>> onCreateCallbacks = new CopyOnWriteArrayList<Consumer<ClientSession>>();
    private final List<Consumer<ClientSession>> onDestroyCallbacks = new CopyOnWriteArrayList<Consumer<ClientSession>>();
    private final ThreadLocal<ClientSession> currentClientSession = new ThreadLocal();

    @Override
    public Subscription addSessionCreatedListener(final Consumer<ClientSession> listener) {
        this.onCreateCallbacks.add(listener);
        return new Subscription(){

            public void unsubscribe() {
                ClientSessionLifecycleHandlerImpl.this.onCreateCallbacks.remove(listener);
            }
        };
    }

    @Override
    public Subscription addSessionDestroyedListener(final Consumer<ClientSession> listener) {
        this.onDestroyCallbacks.add(listener);
        return new Subscription(){

            public void unsubscribe() {
                ClientSessionLifecycleHandlerImpl.this.onDestroyCallbacks.remove(listener);
            }
        };
    }

    @Override
    public void onSessionCreated(ClientSession session) {
        for (Consumer<ClientSession> listener : this.onCreateCallbacks) {
            try {
                listener.accept(session);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while handling onSessionCreated listener", e);
            }
        }
    }

    @Override
    public void onSessionDestroyed(ClientSession session) {
        for (Consumer<ClientSession> listener : this.onDestroyCallbacks) {
            try {
                listener.accept(session);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while handling onSessionDestroyed listener", e);
            }
        }
    }

    public ClientSession getCurrentDolphinSession() {
        return this.currentClientSession.get();
    }

    public void setCurrentSession(ClientSession currentSession) {
        this.currentClientSession.set(currentSession);
    }
}

