/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandlerImpl;
import com.canoo.dp.impl.server.client.HttpClientSessionImpl;
import com.canoo.dp.impl.server.client.MaxSessionCountReachedException;
import com.canoo.platform.core.PlatformConfiguration;
import com.canoo.platform.server.client.ClientSession;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSession;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionManager.class);
    private static final String DOLPHIN_CONTEXT_MAP = "DOLPHIN_CONTEXT_MAP";
    private static final String CLIENT_SESSION_LOCK = "CLIENT_SESSION_LOCK";
    private final PlatformConfiguration configuration;
    private final ClientSessionLifecycleHandlerImpl lifecycleHandler;

    public ClientSessionManager(PlatformConfiguration configuration, ClientSessionLifecycleHandlerImpl lifecycleHandler) {
        this.configuration = configuration;
        this.lifecycleHandler = lifecycleHandler;
    }

    public String createClientSession(HttpSession httpSession) throws MaxSessionCountReachedException {
        if (!this.canAddInSession(httpSession)) {
            throw new MaxSessionCountReachedException();
        }
        HttpClientSessionImpl clientSession = new HttpClientSessionImpl(httpSession);
        this.add(httpSession, clientSession);
        this.lifecycleHandler.onSessionCreated(clientSession);
        LOG.trace("Created new DolphinContext {} in http session {}", (Object)clientSession.getId(), (Object)httpSession.getId());
        return clientSession.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValidClientSession(HttpSession httpSession, String clientSessionId) {
        Lock lock = this.getOrCreateClientSessionLockForHttpSession(httpSession);
        lock.lock();
        try {
            boolean bl = this.getOrCreateClientSessionMapInHttpSession(httpSession).containsKey(clientSessionId);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllClientSessionsInHttpSession(HttpSession httpSession) {
        Lock lock = this.getOrCreateClientSessionLockForHttpSession(httpSession);
        lock.lock();
        try {
            Map<String, ClientSession> map = this.getOrCreateClientSessionMapInHttpSession(httpSession);
            for (ClientSession session : map.values()) {
                this.lifecycleHandler.onSessionDestroyed(session);
            }
            map.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientSessionForThread(HttpSession httpSession, String clientSessionId) {
        Lock lock = this.getOrCreateClientSessionLockForHttpSession(httpSession);
        lock.lock();
        try {
            this.lifecycleHandler.setCurrentSession(this.getOrCreateClientSessionMapInHttpSession(httpSession).get(clientSessionId));
        }
        finally {
            lock.unlock();
        }
    }

    public void resetClientSessionForThread() {
        this.lifecycleHandler.setCurrentSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(HttpSession httpSession, ClientSession clientSession) {
        Lock lock = this.getOrCreateClientSessionLockForHttpSession(httpSession);
        lock.lock();
        try {
            this.getOrCreateClientSessionMapInHttpSession(httpSession).put(clientSession.getId(), clientSession);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canAddInSession(HttpSession httpSession) {
        Lock lock = this.getOrCreateClientSessionLockForHttpSession(httpSession);
        lock.lock();
        try {
            boolean bl = this.getOrCreateClientSessionMapInHttpSession(httpSession).size() < this.configuration.getIntProperty("maxClientsPerSession", 10);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, ClientSession> getOrCreateClientSessionMapInHttpSession(HttpSession session) {
        Assert.requireNonNull((Object)session, (String)"session");
        if (session.getAttribute(DOLPHIN_CONTEXT_MAP) == null) {
            session.setAttribute(DOLPHIN_CONTEXT_MAP, new HashMap());
        }
        return (Map)session.getAttribute(DOLPHIN_CONTEXT_MAP);
    }

    private synchronized Lock getOrCreateClientSessionLockForHttpSession(HttpSession session) {
        Assert.requireNonNull((Object)session, (String)"session");
        if (session.getAttribute(CLIENT_SESSION_LOCK) == null) {
            session.setAttribute(CLIENT_SESSION_LOCK, (Object)new ReentrantLock());
        }
        return (Lock)session.getAttribute(CLIENT_SESSION_LOCK);
    }
}

