/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.servlet.Mutex;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.client.ClientSessionListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionMutextHolder
implements ClientSessionListener {
    private final Map<String, WeakReference<Mutex>> sessionMutexMap = new HashMap<String, WeakReference<Mutex>>();
    private static final String SESSION_MUTEX_ATTRIBUTE = "Session-Mutex";

    @Override
    public void sessionCreated(ClientSession clientSession) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        Mutex mutex = new Mutex();
        clientSession.setAttribute(SESSION_MUTEX_ATTRIBUTE, mutex);
        this.sessionMutexMap.put(clientSession.getId(), new WeakReference<Mutex>(mutex));
    }

    @Override
    public void sessionDestroyed(ClientSession clientSession) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        this.sessionMutexMap.remove(clientSession.getId());
    }

    public Mutex getMutexForClientSession(String sessionId) {
        Assert.requireNonBlank((String)sessionId, (String)"sessionId");
        WeakReference<Mutex> mutexReference = this.sessionMutexMap.get(sessionId);
        Assert.requireNonNull(mutexReference, (String)"mutexReference");
        return (Mutex)mutexReference.get();
    }
}

