/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.server.client.ClientSession;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpClientSessionImpl
implements ClientSession {
    private final Map<String, Object> store;
    private final HttpSession httpSession;
    private final String dolphinSessionId;

    public HttpClientSessionImpl(HttpSession httpSession) {
        this.httpSession = (HttpSession)Assert.requireNonNull((Object)httpSession, (String)"httpSession");
        this.dolphinSessionId = UUID.randomUUID().toString();
        this.store = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.store.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.store.get(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.store.remove(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.store.keySet());
    }

    @Override
    public void invalidate() {
        this.store.clear();
    }

    @Override
    public String getId() {
        return this.dolphinSessionId;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpSession;
    }
}

