/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.client.ClientSessionManager;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpSessionCleanerListener
implements HttpSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionCleanerListener.class);
    private final ClientSessionManager clientSessionManager;

    public HttpSessionCleanerListener(ClientSessionManager clientSessionManager) {
        this.clientSessionManager = clientSessionManager;
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        Assert.requireNonNull((Object)sessionEvent, (String)"sessionEvent");
        LOG.trace("Http session {} destroyed! Will remove all client sessions for the http session.", (Object)sessionEvent.getSession().getId());
        this.clientSessionManager.removeAllClientSessionsInHttpSession(sessionEvent.getSession());
    }
}

