/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.config;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.platform.server.spi.ConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ConfigurationFileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFileLoader.class);
    private static final String DEFAULT_LOCATION = "dolphin.properties";
    private static final String JAR_LOCATION = "META-INF/dolphin.properties";
    private static final String WAR_LOCATION = "WEB-INF/classes/META-INF/dolphin.properties";

    private ConfigurationFileLoader() {
    }

    public static DefaultPlatformConfiguration loadConfiguration() {
        DefaultPlatformConfiguration configuration = ConfigurationFileLoader.createConfiguration();
        Assert.requireNonNull((Object)configuration, (String)"configuration");
        ServiceLoader<ConfigurationProvider> serviceLoader = ServiceLoader.load(ConfigurationProvider.class);
        for (ConfigurationProvider provider : serviceLoader) {
            Map.Entry<String, String> property222;
            Map<String, String> additionalStringProperties = provider.getStringProperties();
            for (Map.Entry<String, String> property222 : additionalStringProperties.entrySet()) {
                if (configuration.containsProperty(property222.getKey())) continue;
                configuration.setProperty((String)property222.getKey(), (String)property222.getValue());
            }
            Map<String, List<String>> additionalListProperties = provider.getListProperties();
            property222 = additionalListProperties.entrySet().iterator();
            while (property222.hasNext()) {
                Map.Entry property3 = (Map.Entry)property222.next();
                if (configuration.containsProperty((String)property3.getKey())) continue;
                configuration.setListProperty((String)property3.getKey(), (List)property3.getValue());
            }
            Map<String, Boolean> additionalBooleanProperties = provider.getBooleanProperties();
            for (Map.Entry entry : additionalBooleanProperties.entrySet()) {
                if (configuration.containsProperty((String)entry.getKey())) continue;
                configuration.setBooleanProperty((String)entry.getKey(), (Boolean)entry.getValue());
            }
            Map<String, Integer> additionalIntegerProperties = provider.getIntegerProperties();
            for (Map.Entry<String, Integer> property5 : additionalIntegerProperties.entrySet()) {
                if (configuration.containsProperty(property5.getKey())) continue;
                configuration.setIntProperty(property5.getKey(), property5.getValue());
            }
            Map<String, Long> map = provider.getLongProperties();
            for (Map.Entry<String, Long> property6 : map.entrySet()) {
                if (configuration.containsProperty(property6.getKey())) continue;
                configuration.setLongProperty(property6.getKey(), property6.getValue());
            }
        }
        LOG.debug("Configuration created with {} properties", (Object)configuration.getPropertyKeys().size());
        if (LOG.isTraceEnabled()) {
            for (String key : configuration.getPropertyKeys()) {
                LOG.debug("Dolphin Platform configured with '{}'='{}'", (Object)key, (Object)configuration.getProperty(key, null));
            }
        }
        return configuration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DefaultPlatformConfiguration createConfiguration() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try (InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_LOCATION);){
                if (inputStream != null) {
                    DefaultPlatformConfiguration defaultPlatformConfiguration = ConfigurationFileLoader.readConfig(inputStream);
                    return defaultPlatformConfiguration;
                }
            }
            inputStream = classLoader.getResourceAsStream(JAR_LOCATION);
            var2_3 = null;
            try {
                if (inputStream != null) {
                    DefaultPlatformConfiguration defaultPlatformConfiguration = ConfigurationFileLoader.readConfig(inputStream);
                    return defaultPlatformConfiguration;
                }
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (var2_3 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            inputStream = classLoader.getResourceAsStream(WAR_LOCATION);
            var2_3 = null;
            try {
                DefaultPlatformConfiguration defaultPlatformConfiguration;
                if (inputStream == null) {
                    LOG.info("Can not read configuration. Maybe no dolphin.properties file is defined. Will use a default configuration!");
                    defaultPlatformConfiguration = new DefaultPlatformConfiguration();
                    return defaultPlatformConfiguration;
                }
                defaultPlatformConfiguration = ConfigurationFileLoader.readConfig(inputStream);
                return defaultPlatformConfiguration;
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (var2_3 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create configuration!", e);
        }
    }

    private static DefaultPlatformConfiguration readConfig(InputStream input) throws IOException {
        Assert.requireNonNull((Object)input, (String)"input");
        Properties prop = new Properties();
        prop.load(input);
        return new DefaultPlatformConfiguration(prop);
    }
}

