/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.config;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.PlatformConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public final class DefaultPlatformConfiguration
implements PlatformConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPlatformConfiguration.class);
    public static final String USE_CROSS_SITE_ORIGIN_FILTER = "useCrossSiteOriginFilter";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "accessControlAllowHeaders";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "accessControlAllowMethods";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "accessControlAllowCredentials";
    public static final String ACCESS_CONTROL_MAXAGE = "accessControlMaxAge";
    public static final String SESSION_TIMEOUT = "sessionTimeout";
    public static final String ROOT_PACKAGE_FOR_CLASSPATH_SCAN = "rootPackageForClasspathScan";
    public static final String MBEAN_REGISTRATION = "mBeanRegistration";
    public static final String PLATFORM_ACTIVE = "active";
    public static final String MAX_CLIENTS_PER_SESSION = "maxClientsPerSession";
    public static final String ID_FILTER_URL_MAPPINGS = "idFilterUrlMappings";
    public static final String CORS_ENDPOINTS_URL_MAPPINGS = "corsUrlMappings";
    public static final int SESSION_TIMEOUT_DEFAULT_VALUE = 900;
    public static final boolean USE_CROSS_SITE_ORIGIN_FILTER_DEFAULT_VALUE = true;
    public static final boolean M_BEAN_REGISTRATION_DEFAULT_VALUE = false;
    public static final boolean ACTIVE_DEFAULT_VALUE = true;
    public static final List<String> ACCESS_CONTROL_ALLOW_HEADERS_DEFAULT_VALUE = Arrays.asList("Content-Type", "x-requested-with", "origin", "authorization", "accept", "client-security-token");
    public static final List<String> ACCESS_CONTROL_ALLOW_METHODS_DEFAULT_VALUE = Arrays.asList("*");
    public static final boolean ACCESS_CONTROL_ALLOW_CREDENTIALS_DEFAULT_VALUE = true;
    public static final long ACCESS_CONTROL_MAX_AGE_DEFAULT_VALUE = 86400L;
    public static final int MAX_CLIENTS_PER_SESSION_DEFAULT_VALUE = 10;
    public static final List<String> ID_FILTER_URL_MAPPINGS_DEFAULT_VALUE = Arrays.asList("/dolphin");
    public static final List<String> CORS_ENDPOINTS_URL_MAPPINGS_DEFAULT_VALUE = Arrays.asList("/*");
    private final Properties internalProperties;

    public DefaultPlatformConfiguration() {
        this(new Properties());
        this.setIntProperty(SESSION_TIMEOUT, 900);
        this.setBooleanProperty(USE_CROSS_SITE_ORIGIN_FILTER, true);
        this.setBooleanProperty(MBEAN_REGISTRATION, false);
        this.setBooleanProperty(PLATFORM_ACTIVE, true);
        this.setListProperty(ACCESS_CONTROL_ALLOW_HEADERS, ACCESS_CONTROL_ALLOW_HEADERS_DEFAULT_VALUE);
        this.setListProperty(ACCESS_CONTROL_ALLOW_METHODS, ACCESS_CONTROL_ALLOW_METHODS_DEFAULT_VALUE);
        this.setBooleanProperty(ACCESS_CONTROL_ALLOW_CREDENTIALS, true);
        this.setLongProperty(ACCESS_CONTROL_MAXAGE, 86400L);
        this.setIntProperty(MAX_CLIENTS_PER_SESSION, 10);
        this.setListProperty(ID_FILTER_URL_MAPPINGS, ID_FILTER_URL_MAPPINGS_DEFAULT_VALUE);
        this.setBooleanProperty("corsActive", true);
        this.setBooleanProperty("timingActive", true);
        this.setListProperty(CORS_ENDPOINTS_URL_MAPPINGS, CORS_ENDPOINTS_URL_MAPPINGS_DEFAULT_VALUE);
    }

    public DefaultPlatformConfiguration(Properties internalProperties) {
        Assert.requireNonNull((Object)internalProperties, (String)"internalProperties");
        this.internalProperties = internalProperties;
    }

    public boolean containsProperty(String key) {
        return this.internalProperties.containsKey(key);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.internalProperties.getProperty(key, defaultValue + ""));
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public int getIntProperty(String key, int defaultValue) {
        return Integer.parseInt(this.internalProperties.getProperty(key, defaultValue + ""));
    }

    public long getLongProperty(String key, long defaultValue) {
        return Long.parseLong(this.internalProperties.getProperty(key, defaultValue + ""));
    }

    public List<String> getListProperty(String key) {
        return this.getListProperty(key, Collections.emptyList());
    }

    public List<String> getListProperty(String key, List<String> defaultValues) {
        String value = this.internalProperties.getProperty(key);
        if (value != null) {
            return Arrays.asList(value.split(","));
        }
        return defaultValues;
    }

    public String getProperty(String key, String defaultValue) {
        return this.internalProperties.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.internalProperties.getProperty(key);
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> ret = new HashSet<String>();
        for (Object key : this.internalProperties.keySet()) {
            if (key == null) continue;
            ret.add(key.toString());
        }
        return ret;
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setLongProperty(String key, long value) {
        this.setProperty(key, Long.toString(value));
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setListProperty(String key, List<String> values) {
        if (values == null) {
            this.setProperty(key, null);
        } else if (values.isEmpty()) {
            this.setProperty(key, "");
        } else {
            StringBuilder builder = new StringBuilder();
            for (String value : values) {
                builder.append(value + ", ");
            }
            builder.setLength(builder.length() - 2);
            this.setProperty(key, builder.toString());
        }
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            LOG.warn("Setting property '{}' to null value will be ignored.");
        } else {
            this.internalProperties.setProperty(key, value);
        }
    }

    public void log() {
        Set<Map.Entry<Object, Object>> properties = this.internalProperties.entrySet();
        for (Map.Entry<Object, Object> property : properties) {
            LOG.debug("Dolphin Platform starts with value for " + property.getKey() + " = " + property.getValue());
        }
    }
}

