/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.mbean;

import com.canoo.dp.impl.server.mbean.MBeanDescription;
import com.canoo.platform.core.functional.Subscription;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class MBeanRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistry.class);
    private static final MBeanRegistry INSTANCE = new MBeanRegistry();
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private AtomicBoolean mbeanSupport = new AtomicBoolean(true);
    private AtomicLong idGenerator = new AtomicLong(0L);

    public Subscription register(Object mBean, MBeanDescription description) {
        return this.register(mBean, description.getMBeanName(this.getNextId()));
    }

    public Subscription register(Object mBean, String name) {
        try {
            if (this.mbeanSupport.get()) {
                final ObjectName objectName = new ObjectName(name);
                this.server.registerMBean(mBean, objectName);
                return new Subscription(){

                    public void unsubscribe() {
                        try {
                            MBeanRegistry.this.server.unregisterMBean(objectName);
                        }
                        catch (JMException e) {
                            throw new RuntimeException("Can not unsubscribe!", e);
                        }
                    }
                };
            }
            return new Subscription(){

                public void unsubscribe() {
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Can not register MBean!", e);
        }
    }

    public boolean isMbeanSupport() {
        return this.mbeanSupport.get();
    }

    public void setMbeanSupport(boolean mbeanSupport) {
        this.mbeanSupport.set(mbeanSupport);
    }

    private String getNextId() {
        return Long.toString(this.idGenerator.getAndIncrement());
    }

    public static MBeanRegistry getInstance() {
        return INSTANCE;
    }
}

