/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.scanner;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.server.spi.components.ClasspathScanner;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class DefaultClasspathScanner
implements ClasspathScanner {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClasspathScanner.class);
    private final Reflections reflections;

    public DefaultClasspathScanner(String rootPackage) {
        this(Collections.singletonList(rootPackage));
    }

    public DefaultClasspathScanner(String ... rootPackages) {
        this(Arrays.asList(rootPackages));
    }

    public DefaultClasspathScanner(List<String> rootPackages) {
        Assert.requireNonNull(rootPackages, (String)"rootPackages");
        LOG.trace("Scanning class path for root packages {}", (Object)Arrays.toString(rootPackages.toArray()));
        ConfigurationBuilder configuration = ConfigurationBuilder.build((Object[])new Object[]{DefaultClasspathScanner.class.getClassLoader()});
        configuration = configuration.setExpandSuperTypes(false);
        if (rootPackages.size() > 0) {
            configuration = configuration.forPackages(rootPackages.toArray(new String[rootPackages.size()]));
            configuration = configuration.setUrls((Collection)rootPackages.stream().map(rootPackage -> ClasspathHelper.forPackage((String)rootPackage, (ClassLoader[])new ClassLoader[0])).flatMap(list -> list.stream()).collect(Collectors.toList()));
            configuration = configuration.filterInputsBy((Predicate)new FilterBuilder().includePackage(rootPackages.toArray(new String[rootPackages.size()])));
        }
        try {
            Enumeration<URL> res = DefaultClasspathScanner.class.getClassLoader().getResources("");
            configuration.getUrls().addAll(Collections.list(res));
        }
        catch (IOException e) {
            throw new RuntimeException("Error in Dolphin Platform controller class scan", e);
        }
        Set urls = configuration.getUrls();
        ArrayList<URL> toRemove = new ArrayList<URL>();
        for (URL url : urls) {
            if (!url.toString().endsWith(".jnilib")) continue;
            toRemove.add(url);
        }
        LOG.trace("Configuration Urls {}", (Object)Arrays.toString(configuration.getUrls().toArray()));
        for (URL url : toRemove) {
            LOG.trace("Url removed {}", (Object)url.toString());
            configuration.getUrls().remove(url);
        }
        this.reflections = new Reflections((Configuration)configuration);
    }

    @Override
    public synchronized Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Assert.requireNonNull(annotation, (String)"annotation");
        return this.reflections.getTypesAnnotatedWith(annotation);
    }
}

