/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.servlet;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.platform.core.PlatformConfiguration;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class CrossSiteOriginFilter
implements Filter {
    private final PlatformConfiguration configuration;

    public CrossSiteOriginFilter(PlatformConfiguration configuration) {
        this.configuration = (PlatformConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String accessControlAllowHeaders = "dolphin_platform_intern_dolphinClientId";
        String headerValues = this.getAsCommaSeparatedList(this.configuration.getListProperty("accessControlAllowHeaders", DefaultPlatformConfiguration.ACCESS_CONTROL_ALLOW_HEADERS_DEFAULT_VALUE));
        if (!headerValues.isEmpty()) {
            accessControlAllowHeaders = accessControlAllowHeaders + ", " + headerValues;
        }
        String allowedMethods = this.getAsCommaSeparatedList(this.configuration.getListProperty("accessControlAllowMethods", DefaultPlatformConfiguration.ACCESS_CONTROL_ALLOW_METHODS_DEFAULT_VALUE));
        String clientOrigin = req.getHeader("origin");
        resp.setHeader("Access-Control-Allow-Origin", clientOrigin);
        if (!allowedMethods.isEmpty()) {
            resp.setHeader("Access-Control-Allow-Methods", allowedMethods);
        }
        resp.setHeader("Access-Control-Allow-Headers", accessControlAllowHeaders);
        resp.setHeader("Access-Control-Expose-Headers", "dolphin_platform_intern_dolphinClientId");
        resp.setHeader("Access-Control-Allow-Credentials", "" + this.configuration.getBooleanProperty("accessControlAllowCredentials", true));
        resp.setHeader("Access-Control-Max-Age", "" + this.configuration.getLongProperty("accessControlMaxAge", 86400L));
        chain.doFilter(request, response);
    }

    public String getAsCommaSeparatedList(List<String> headers) {
        Assert.requireNonNull(headers, (String)"headers");
        StringBuilder values = new StringBuilder("");
        if (headers.size() > 0) {
            for (int i = 0; i < headers.size(); ++i) {
                values.append(headers.get(i));
                if (i >= headers.size() - 1) continue;
                values.append(",");
            }
        }
        return values.toString();
    }

    public void destroy() {
    }
}

