/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.servlet;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.servlet.Mutex;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpSessionMutexHolder
implements HttpSessionListener {
    private final Map<String, WeakReference<Mutex>> sessionMutexMap = new HashMap<String, WeakReference<Mutex>>();
    private static final String SESSION_MUTEX_ATTRIBUTE = "Session-Mutex";

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        Assert.requireNonNull((Object)sessionEvent, (String)"sessionEvent");
        HttpSession session = sessionEvent.getSession();
        Assert.requireNonNull((Object)session, (String)"session");
        Mutex mutex = new Mutex();
        session.setAttribute(SESSION_MUTEX_ATTRIBUTE, (Object)mutex);
        this.sessionMutexMap.put(session.getId(), new WeakReference<Mutex>(mutex));
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        Assert.requireNonNull((Object)sessionEvent, (String)"sessionEvent");
        HttpSession session = sessionEvent.getSession();
        Assert.requireNonNull((Object)session, (String)"session");
        this.sessionMutexMap.remove(session.getId());
    }

    public Mutex getMutexForHttpSession(String sessionId) {
        Assert.requireNonBlank((String)sessionId, (String)"sessionId");
        WeakReference<Mutex> mutexReference = this.sessionMutexMap.get(sessionId);
        Assert.requireNonNull(mutexReference, (String)"mutexReference");
        return (Mutex)mutexReference.get();
    }
}

