/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.servlet;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.PlatformConfiguration;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpSessionTimeoutListener
implements HttpSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSessionTimeoutListener.class);
    private final int sessionTimeoutInSeconds;

    public HttpSessionTimeoutListener(PlatformConfiguration configuration) {
        this.sessionTimeoutInSeconds = configuration.getIntProperty("sessionTimeout", 900);
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        Assert.requireNonNull((Object)sessionEvent, (String)"sessionEvent");
        try {
            sessionEvent.getSession().setMaxInactiveInterval(this.sessionTimeoutInSeconds);
        }
        catch (Exception e) {
            LOG.warn("Can not set the defined session timeout!", (Throwable)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
    }
}

