/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.servlet;

import com.canoo.dp.impl.server.servlet.HttpServletResponseCopier;
import com.canoo.dp.impl.server.timing.ServerTimingImpl;
import com.canoo.platform.server.timing.Metric;
import com.canoo.platform.server.timing.ServerTiming;
import java.io.IOException;
import java.time.Duration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;

@API(since="1.0.0-RC5", status=API.Status.INTERNAL)
public class ServerTimingFilter
implements Filter {
    private static final ThreadLocal<ServerTimingImpl> timingLocal = new ThreadLocal();
    private final boolean addServerTiming;

    public ServerTimingFilter(boolean addServerTiming) {
        this.addServerTiming = addServerTiming;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponseCopier responseWrapper = new HttpServletResponseCopier((HttpServletResponse)response);
        ServerTimingImpl timing = new ServerTimingImpl();
        timingLocal.set(timing);
        try {
            Metric totalMetric = timing.start("total", "total duration of the request");
            chain.doFilter(request, (ServletResponse)responseWrapper);
            totalMetric.stop();
        }
        finally {
            if (this.addServerTiming) {
                timing.dump((HttpServletResponse)response);
            } else {
                timing.clear();
            }
            timingLocal.set(null);
            responseWrapper.flushBuffer();
        }
    }

    public void destroy() {
    }

    public static ServerTiming getCurrentTiming() {
        ServerTimingImpl timing = timingLocal.get();
        if (timing == null) {
            return new ServerTiming(){

                @Override
                public Metric start(final String name, final String description) {
                    return new Metric(){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public String getDescription() {
                            return description;
                        }

                        @Override
                        public Duration getDuration() {
                            return null;
                        }

                        @Override
                        public void stop() throws IllegalStateException {
                        }
                    };
                }
            };
        }
        return timing;
    }
}

