/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.timing;

import com.canoo.platform.server.timing.Metric;
import java.time.Duration;
import java.time.ZonedDateTime;

public class MetricImpl
implements Metric {
    private final String name;
    private final String description;
    private final ZonedDateTime startTime;
    private Duration duration;

    public MetricImpl(String name, String description) {
        this.name = name;
        this.description = description;
        this.startTime = ZonedDateTime.now();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public void stop() {
        if (this.duration != null) {
            throw new IllegalStateException("Metric '" + this.name + "' was already stopped!");
        }
        this.duration = Duration.between(this.startTime, ZonedDateTime.now());
    }
}

