/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.server.timing;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.timing.MetricImpl;
import com.canoo.platform.server.timing.Metric;
import com.canoo.platform.server.timing.ServerTiming;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;

public class ServerTimingImpl
implements ServerTiming {
    private List<Metric> metrics = new ArrayList<Metric>();

    public void clear() {
        this.metrics.clear();
    }

    public void dump(HttpServletResponse response) {
        Assert.requireNonNull((Object)response, (String)"response");
        String headerName = "Server-Timing";
        String content = this.metrics.stream().map(m -> this.convert((Metric)m)).reduce("", (a, b) -> a + "," + b);
        if (content.length() > 0) {
            response.addHeader("Server-Timing", content.substring(1));
        }
        this.clear();
    }

    private String convert(Metric metric) {
        Assert.requireNonNull((Object)metric, (String)"metric");
        Duration duration = metric.getDuration();
        String description = metric.getDescription();
        String durPart = Optional.ofNullable(duration).map(d -> ";dur=" + Math.max(1.0, (double)d.toNanos()) / 1000000.0).orElse("");
        String descPart = Optional.ofNullable(description).map(d -> ";desc=\"" + d + "\"").orElse("");
        return metric.getName() + durPart + descPart;
    }

    @Override
    public Metric start(String name, String description) {
        MetricImpl metric = new MetricImpl(name, description);
        this.metrics.add(metric);
        return metric;
    }
}

