/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.impl.dp.spring.test;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.impl.dp.spring.test.CommunicationMonitorImpl;
import com.canoo.impl.dp.spring.test.TestClientContext;
import com.canoo.platform.remoting.client.ControllerProxy;
import com.canoo.platform.remoting.client.Param;
import com.canoo.platform.spring.test.CommunicationMonitor;
import com.canoo.platform.spring.test.ControllerTestException;
import com.canoo.platform.spring.test.ControllerUnderTest;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientTestFactory {
    public static <T> ControllerUnderTest<T> createController(TestClientContext clientContext, String controllerName) {
        Assert.requireNonNull((Object)clientContext, (String)"clientContext");
        Assert.requireNonBlank((String)controllerName, (String)"controllerName");
        try {
            ControllerProxy proxy = (ControllerProxy)clientContext.createController(controllerName).get();
            return new ControllerUnderTestWrapper(clientContext, proxy);
        }
        catch (Exception e) {
            throw new ControllerTestException("Can't create controller proxy", e);
        }
    }

    static class ControllerUnderTestWrapper<T>
    implements ControllerUnderTest<T> {
        private final ControllerProxy<T> proxy;
        private final TestClientContext clientContext;

        public ControllerUnderTestWrapper(TestClientContext clientContext, ControllerProxy<T> controllerProxy) {
            this.clientContext = clientContext;
            this.proxy = controllerProxy;
        }

        @Override
        public T getModel() {
            return (T)this.proxy.getModel();
        }

        @Override
        public void invoke(String actionName, Param ... params) {
            try {
                this.proxy.invoke(actionName, params).get();
            }
            catch (Exception e) {
                throw new ControllerTestException("Error in action invocation", e);
            }
        }

        @Override
        public void invoke(String actionName, Map<String, Object> params) {
            try {
                this.proxy.invoke(actionName, params).get();
            }
            catch (Exception e) {
                throw new ControllerTestException("Error in action invocation", e);
            }
        }

        @Override
        public CommunicationMonitor createMonitor() {
            return new CommunicationMonitorImpl(this.clientContext);
        }

        @Override
        public void destroy() {
            try {
                this.proxy.destroy().get();
            }
            catch (Exception e) {
                throw new ControllerTestException("Error in destroy", e);
            }
        }

        @Override
        public <S> ControllerUnderTest<S> createController(String childControllerName) {
            try {
                ControllerProxy controllerProxy = (ControllerProxy)this.proxy.createController(childControllerName).get();
                return new ControllerUnderTestWrapper<T>(this.clientContext, controllerProxy);
            }
            catch (Exception e) {
                throw new ControllerTestException("Error in sub controller", e);
            }
        }
    }
}

