/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.impl.dp.spring.test;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.impl.dp.spring.test.TestClientContext;
import com.canoo.platform.spring.test.CommunicationMonitor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class CommunicationMonitorImpl
implements CommunicationMonitor {
    private static final long SLEEP_TIME = 100L;
    private final TestClientContext clientContext;
    private final AtomicBoolean ping = new AtomicBoolean();

    public CommunicationMonitorImpl(TestClientContext clientContext) {
        this.clientContext = (TestClientContext)Assert.requireNonNull((Object)clientContext, (String)"clientContext");
    }

    private void sendPing() {
        this.clientContext.sendPing();
    }

    private void sendPing(long time, TimeUnit unit) {
        this.clientContext.sendPing(time, unit);
    }

    @Override
    public void await(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        Assert.requireNonNull((Object)((Object)unit), (String)"unit");
        long endTime = System.currentTimeMillis() + unit.toMillis(time);
        this.ping.set(true);
        while (this.ping.get() && System.currentTimeMillis() < endTime) {
            long leftTime = endTime - System.currentTimeMillis();
            this.sendPing(Math.max(0L, leftTime - 100L), TimeUnit.MILLISECONDS);
            Thread.sleep(100L);
        }
        if (this.ping.get()) {
            throw new TimeoutException("Timeout!");
        }
    }

    @Override
    public void signal() {
        this.ping.set(false);
    }
}

