/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.impl.dp.spring.test;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.server.binding.PropertyBinderImpl;
import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandler;
import com.canoo.dp.impl.server.client.ClientSessionLifecycleHandlerImpl;
import com.canoo.dp.impl.server.context.ClientSessionExecutorImpl;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.context.DolphinContextProvider;
import com.canoo.dp.impl.server.event.DefaultDolphinEventBus;
import com.canoo.impl.dp.spring.test.TestClientContext;
import com.canoo.impl.dp.spring.test.TestClientScope;
import com.canoo.impl.dp.spring.test.TestConfiguration;
import com.canoo.platform.remoting.BeanManager;
import com.canoo.platform.remoting.server.ClientSessionExecutor;
import com.canoo.platform.remoting.server.RemotingContext;
import com.canoo.platform.remoting.server.binding.PropertyBinder;
import com.canoo.platform.remoting.server.event.RemotingEventBus;
import com.canoo.platform.server.client.ClientSession;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpSession;
import org.apiguardian.api.API;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinPlatformSpringTestBootstrap {
    @Bean
    @org.springframework.context.annotation.Scope(value="singleton")
    protected TestConfiguration createTestConfiguration(WebApplicationContext context, HttpSession httpSession) {
        Assert.requireNonNull((Object)context, (String)"context");
        try {
            return new TestConfiguration(context, httpSession);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create test configuration", e);
        }
    }

    @Bean
    @org.springframework.context.annotation.Scope(value="singleton")
    protected TestClientContext createClientContext(TestConfiguration testConfiguration) {
        Assert.requireNonNull((Object)testConfiguration, (String)"testConfiguration");
        return testConfiguration.getClientContext();
    }

    @Bean
    @org.springframework.context.annotation.Scope(value="singleton")
    protected DolphinContext createServerContext(TestConfiguration testConfiguration) {
        Assert.requireNonNull((Object)testConfiguration, (String)"testConfiguration");
        return testConfiguration.getDolphinTestContext();
    }

    @Bean(name={"beanManager"})
    @org.springframework.context.annotation.Scope(value="singleton")
    protected BeanManager createManager(TestConfiguration testConfiguration) {
        Assert.requireNonNull((Object)testConfiguration, (String)"testConfiguration");
        return testConfiguration.getDolphinTestContext().getBeanManager();
    }

    @Bean(name={"dolphinSession"})
    @org.springframework.context.annotation.Scope(value="singleton")
    protected ClientSession createDolphinSession(TestConfiguration testConfiguration) {
        Assert.requireNonNull((Object)testConfiguration, (String)"testConfiguration");
        return testConfiguration.getDolphinTestContext().getClientSession();
    }

    @Bean(name={"remotingContext"})
    @org.springframework.context.annotation.Scope(value="singleton")
    protected RemotingContext createRemotingContext(final TestConfiguration testConfiguration, final PropertyBinder propertyBinder, final RemotingEventBus eventBus) {
        Assert.requireNonNull((Object)testConfiguration, (String)"testConfiguration");
        Assert.requireNonNull((Object)propertyBinder, (String)"propertyBinder");
        Assert.requireNonNull((Object)eventBus, (String)"eventBus");
        return new RemotingContext(){

            public String getId() {
                return testConfiguration.getDolphinTestContext().getClientSession().getId();
            }

            public ClientSessionExecutor createSessionExecutor() {
                return new ClientSessionExecutorImpl(new Executor(){

                    @Override
                    public void execute(Runnable command) {
                        testConfiguration.getDolphinTestContext().runLater(command);
                    }
                });
            }

            public PropertyBinder getBinder() {
                return propertyBinder;
            }

            public BeanManager getBeanManager() {
                return testConfiguration.getDolphinTestContext().getBeanManager();
            }

            public RemotingEventBus getEventBus() {
                return eventBus;
            }

            public ClientSession getClientSession() {
                return testConfiguration.getDolphinTestContext().getClientSession();
            }
        };
    }

    @Bean(name={"dolphinEventBus"})
    @org.springframework.context.annotation.Scope(value="singleton")
    protected RemotingEventBus createEventBus(final TestConfiguration testConfiguration) {
        Assert.requireNonNull((Object)testConfiguration, (String)"testConfiguration");
        DolphinContextProvider contextProvider = new DolphinContextProvider(){

            public DolphinContext getContext(ClientSession clientSession) {
                return this.getCurrentDolphinContext();
            }

            public DolphinContext getContextById(String clientSessionId) {
                return this.getCurrentDolphinContext();
            }

            public DolphinContext getCurrentDolphinContext() {
                return testConfiguration.getDolphinTestContext();
            }
        };
        DefaultDolphinEventBus eventBus = new DefaultDolphinEventBus();
        eventBus.init(contextProvider, (ClientSessionLifecycleHandler)new ClientSessionLifecycleHandlerImpl());
        return eventBus;
    }

    @Bean(name={"propertyBinder"})
    @org.springframework.context.annotation.Scope(value="singleton")
    protected PropertyBinder createPropertyBinder() {
        return new PropertyBinderImpl();
    }

    @Bean(name={"customScopeConfigurer"})
    public static CustomScopeConfigurer createClientScope(ClientSession clientSession) {
        Assert.requireNonNull((Object)clientSession, (String)"clientSession");
        CustomScopeConfigurer configurer = new CustomScopeConfigurer();
        configurer.addScope("client", (Scope)new TestClientScope(clientSession));
        return configurer;
    }
}

