/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.impl.dp.spring.test;

import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.client.legacy.communication.AbstractClientConnector;
import com.canoo.dp.impl.platform.client.session.ClientSessionStoreImpl;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.client.HttpClientSessionImpl;
import com.canoo.dp.impl.server.config.ConfigurationFileLoader;
import com.canoo.dp.impl.server.config.DefaultPlatformConfiguration;
import com.canoo.dp.impl.server.config.RemotingConfiguration;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.controller.ControllerRepository;
import com.canoo.dp.impl.server.scanner.DefaultClasspathScanner;
import com.canoo.impl.dp.spring.test.DolphinTestClientConnector;
import com.canoo.impl.dp.spring.test.TestClientContext;
import com.canoo.impl.dp.spring.test.TestClientContextImpl;
import com.canoo.impl.dp.spring.test.TestDolphinContext;
import com.canoo.impl.dp.spring.test.TestSpringManagedBeanFactory;
import com.canoo.platform.client.PlatformClient;
import com.canoo.platform.client.session.ClientSessionStore;
import com.canoo.platform.core.PlatformConfiguration;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.spi.components.ClasspathScanner;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpSession;
import org.apiguardian.api.API;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

@API(since="0.x", status=API.Status.INTERNAL)
public class TestConfiguration {
    private final DolphinContext dolphinTestContext;
    private final TestClientContext clientContext;

    public TestConfiguration(WebApplicationContext context, HttpSession httpSession) throws Exception {
        Assert.requireNonNull((Object)context, (String)"context");
        Assert.requireNonNull((Object)httpSession, (String)"httpSession");
        DefaultPlatformConfiguration defaultPlatformConfiguration = ConfigurationFileLoader.loadConfiguration();
        RemotingConfiguration remotingConfiguration = new RemotingConfiguration((PlatformConfiguration)defaultPlatformConfiguration);
        ExecutorService clientExecutor = Executors.newSingleThreadExecutor();
        ClientSessionStoreImpl clientSessionStore = new ClientSessionStoreImpl();
        Function<ClientModelStore, AbstractClientConnector> connectorProvider = s -> new DolphinTestClientConnector((ClientModelStore)s, clientExecutor, c -> this.sendToServer((List<Command>)c));
        this.clientContext = new TestClientContextImpl(PlatformClient.getClientConfiguration(), new URI("http://dummy"), connectorProvider, (ClientSessionStore)clientSessionStore);
        ControllerRepository controllerRepository = new ControllerRepository((ClasspathScanner)new DefaultClasspathScanner(defaultPlatformConfiguration.getListProperty("rootPackageForClasspathScan")));
        TestSpringManagedBeanFactory containerManager = new TestSpringManagedBeanFactory((ApplicationContext)context);
        containerManager.init(context.getServletContext());
        DolphinContextProviderMock dolphinContextProviderMock = new DolphinContextProviderMock();
        this.dolphinTestContext = new TestDolphinContext(remotingConfiguration, (ClientSession)new HttpClientSessionImpl(httpSession), dolphinContextProviderMock, (ManagedBeanFactory)containerManager, controllerRepository, this.createEmptyCallback());
        dolphinContextProviderMock.setCurrentContext(this.dolphinTestContext);
    }

    private Consumer<DolphinContext> createEmptyCallback() {
        return c -> {};
    }

    private List<Command> sendToServer(List<Command> commandList) {
        return this.dolphinTestContext.handle(commandList);
    }

    public DolphinContext getDolphinTestContext() {
        return this.dolphinTestContext;
    }

    public TestClientContext getClientContext() {
        return this.clientContext;
    }

    private class DolphinContextProviderMock
    implements ClientSessionProvider {
        private DolphinContext currentContext;

        private DolphinContextProviderMock() {
        }

        public void setCurrentContext(DolphinContext currentContext) {
            this.currentContext = currentContext;
        }

        public ClientSession getCurrentClientSession() {
            return this.currentContext.getClientSession();
        }
    }
}

