/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.impl.dp.spring.test;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.legacy.commands.StartLongPollCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.server.client.ClientSessionProvider;
import com.canoo.dp.impl.server.config.RemotingConfiguration;
import com.canoo.dp.impl.server.context.DolphinContext;
import com.canoo.dp.impl.server.controller.ControllerRepository;
import com.canoo.dp.impl.server.legacy.communication.CommandHandler;
import com.canoo.impl.dp.spring.test.PingCommand;
import com.canoo.platform.server.client.ClientSession;
import com.canoo.platform.server.spi.components.ManagedBeanFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public class TestDolphinContext
extends DolphinContext {
    private final BlockingQueue<Runnable> callLaterTasks = new LinkedBlockingQueue<Runnable>();

    public TestDolphinContext(RemotingConfiguration configuration, ClientSession clientSession, ClientSessionProvider clientSessionProvider, ManagedBeanFactory beanFactory, ControllerRepository controllerRepository, Consumer<DolphinContext> onDestroyCallback) {
        super(configuration, clientSession, clientSessionProvider, beanFactory, controllerRepository, onDestroyCallback);
        this.getServerConnector().getRegistry().register(PingCommand.class, new CommandHandler(){

            public void handleCommand(Command command, List response) {
            }
        });
    }

    public List<Command> handle(List<Command> commands) {
        ArrayList<Command> commandsWithFackedLongPool = new ArrayList<Command>(commands);
        commandsWithFackedLongPool.add((Command)new StartLongPollCommand());
        return super.handle(commandsWithFackedLongPool);
    }

    protected void onLongPoll() {
        while (!this.callLaterTasks.isEmpty()) {
            ((Runnable)this.callLaterTasks.poll()).run();
        }
    }

    public <T> Future<T> callLater(Callable<T> callable) {
        Assert.requireNonNull(callable, (String)"callable");
        CompletableFuture result = new CompletableFuture();
        this.callLaterTasks.offer(() -> {
            try {
                Object taskResult = callable.call();
                result.complete(taskResult);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

