/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.spring.test;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.impl.dp.spring.test.ClientTestFactory;
import com.canoo.impl.dp.spring.test.DolphinPlatformSpringTestBootstrap;
import com.canoo.impl.dp.spring.test.TestClientContext;
import com.canoo.platform.spring.test.ControllerTest;
import com.canoo.platform.spring.test.ControllerTestException;
import com.canoo.platform.spring.test.ControllerUnderTest;
import org.apiguardian.api.API;
import org.junit.Rule;
import org.junit.rules.ExternalResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

@SpringBootTest
@ContextConfiguration(classes={DolphinPlatformSpringTestBootstrap.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@API(since="0.x", status=API.Status.MAINTAINED)
public abstract class SpringJUnitControllerTest
extends AbstractJUnit4SpringContextTests
implements ControllerTest {
    @Autowired
    private TestClientContext clientContext;
    @Rule
    public ExternalResource clientConnector = new ExternalResource(){

        protected void before() throws Throwable {
            super.before();
            SpringJUnitControllerTest.this.clientContext.connect().get();
        }

        protected void after() {
            super.after();
            try {
                SpringJUnitControllerTest.this.clientContext.disconnect().get();
            }
            catch (Exception e) {
                throw new ControllerTestException("Can not disconnect client context!", e);
            }
        }
    };

    @Override
    public <T> ControllerUnderTest<T> createController(String controllerName) {
        Assert.requireNonBlank((String)controllerName, (String)"controllerName");
        try {
            return ClientTestFactory.createController(this.clientContext, controllerName);
        }
        catch (Exception e) {
            throw new ControllerTestException("Can't create controller proxy", e);
        }
    }
}

