/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.spring.test;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.impl.dp.spring.test.ClientTestFactory;
import com.canoo.impl.dp.spring.test.DolphinPlatformSpringTestBootstrap;
import com.canoo.impl.dp.spring.test.TestClientContext;
import com.canoo.platform.spring.test.ControllerTest;
import com.canoo.platform.spring.test.ControllerTestException;
import com.canoo.platform.spring.test.ControllerUnderTest;
import org.apiguardian.api.API;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

@SpringBootTest
@ContextConfiguration(classes={DolphinPlatformSpringTestBootstrap.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@API(since="0.x", status=API.Status.MAINTAINED)
public abstract class SpringTestNGControllerTest
extends AbstractTestNGSpringContextTests
implements ControllerTest {
    @Autowired
    private TestClientContext clientContext;

    @BeforeMethod(alwaysRun=true)
    protected void connectClientContext() {
        try {
            this.clientContext.connect().get();
        }
        catch (Exception e) {
            throw new ControllerTestException("Can not connect client context!", e);
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void disconnectClientContext() {
        try {
            this.clientContext.disconnect().get();
        }
        catch (Exception e) {
            throw new ControllerTestException("Can not disconnect client context!", e);
        }
    }

    @Override
    public <T> ControllerUnderTest<T> createController(String controllerName) {
        Assert.requireNonBlank((String)controllerName, (String)"controllerName");
        try {
            return ClientTestFactory.createController(this.clientContext, controllerName);
        }
        catch (Exception e) {
            throw new ControllerTestException("Can't create controller proxy", e);
        }
    }
}

