/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.IJavetEngine;
import com.caoccao.javet.interop.engine.IJavetEngineGuard;
import com.caoccao.javet.interop.engine.JavetEngineConfig;
import com.caoccao.javet.utils.JavetDateTimeUtils;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class JavetEngineGuard
implements IJavetEngineGuard {
    protected static final boolean IS_IN_DEBUG_MODE = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    protected boolean closed;
    protected Future<?> future;
    protected IJavetEngine<?> iJavetEngine;
    protected volatile boolean quitting;
    protected boolean skipInDebugMode;
    protected long timeoutMillis;
    protected V8Runtime v8Runtime;

    public JavetEngineGuard(IJavetEngine<?> iJavetEngine, V8Runtime v8Runtime, long timeoutMills) {
        Objects.requireNonNull(iJavetEngine);
        this.closed = false;
        this.iJavetEngine = iJavetEngine;
        this.quitting = false;
        this.skipInDebugMode = true;
        this.timeoutMillis = timeoutMills;
        this.v8Runtime = v8Runtime;
        this.future = this.iJavetEngine.getConfig().getExecutorService().submit(this);
    }

    @Override
    public void cancel() {
        this.quitting = true;
    }

    @Override
    public void close() throws JavetException {
        this.cancel();
        if (!this.future.isDone() && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
        this.closed = true;
    }

    @Override
    public void disableInDebugMode() {
        this.skipInDebugMode = true;
    }

    @Override
    public void enableInDebugMode() {
        this.skipInDebugMode = false;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    protected ZonedDateTime getUTCNow() {
        return JavetDateTimeUtils.getUTCNow();
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.v8Runtime == null || this.v8Runtime.isClosed();
    }

    public boolean isQuitting() {
        return this.quitting;
    }

    @Override
    public void run() {
        JavetEngineConfig config = this.iJavetEngine.getConfig();
        IJavetLogger logger = config.getJavetLogger();
        ZonedDateTime startZonedDateTime = this.getUTCNow();
        while (!(this.isQuitting() || !this.iJavetEngine.isActive() || this.skipInDebugMode && IS_IN_DEBUG_MODE)) {
            ZonedDateTime currentZonedDateTime = this.getUTCNow();
            if (startZonedDateTime.plusNanos(TimeUnit.MILLISECONDS.toNanos(this.timeoutMillis)).isBefore(currentZonedDateTime)) {
                try {
                    if (!this.v8Runtime.isInUse()) break;
                    this.v8Runtime.terminateExecution();
                    Duration duration = Duration.between(startZonedDateTime, currentZonedDateTime);
                    logger.logWarn("Execution was terminated after {0}ms.", duration.toMillis());
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                break;
            }
            try {
                Thread.sleep(config.getEngineGuardCheckIntervalMillis());
            }
            catch (Throwable throwable) {}
        }
        this.quitting = true;
    }

    @Override
    public void setTimeoutMillis(long timeoutSeconds) {
        this.timeoutMillis = timeoutSeconds;
    }
}

