/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import java.util.ArrayList;
import java.util.List;

public class V8RuntimeObserverAverageCallbackContextCount
implements IV8RuntimeObserver<Integer> {
    protected final List<Integer> callbackContextCountList;

    public V8RuntimeObserverAverageCallbackContextCount() {
        this(256);
    }

    public V8RuntimeObserverAverageCallbackContextCount(int capacity) {
        this.callbackContextCountList = new ArrayList<Integer>(capacity);
    }

    @Override
    public Integer getResult() {
        int averageCallbackContextCount = 0;
        if (!this.callbackContextCountList.isEmpty()) {
            int totalCallbackContextCount = 0;
            for (int callbackContextCount : this.callbackContextCountList) {
                totalCallbackContextCount += callbackContextCount;
            }
            int v8RuntimeCount = this.callbackContextCountList.size();
            averageCallbackContextCount = totalCallbackContextCount / v8RuntimeCount;
        }
        return averageCallbackContextCount;
    }

    @Override
    public boolean observe(V8Runtime v8Runtime) {
        this.callbackContextCountList.add(v8Runtime.getCallbackContextCount());
        return true;
    }

    @Override
    public void reset() {
        this.callbackContextCountList.clear();
    }
}

