/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.converters.JavetProxyConverter;
import com.caoccao.javet.interop.proxy.BaseJavetProxySymbolConverter;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.virtual.V8VirtualIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class JavetProxySymbolIterableConverter<T>
extends BaseJavetProxySymbolConverter<T> {
    protected static final JavetProxyConverter PROXY_CONVERTER = new JavetProxyConverter();

    public JavetProxySymbolIterableConverter(V8Runtime v8Runtime, T targetObject) {
        super(v8Runtime, targetObject);
    }

    @Override
    public V8Value toV8Value(V8Value ... v8Values) throws JavetException {
        Iterator<Object> iterator = null;
        if (this.targetObject instanceof Iterable) {
            iterator = ((Iterable)this.targetObject).iterator();
        } else if (this.targetObject instanceof Map) {
            iterator = ((Map)this.targetObject).keySet().iterator();
        } else if (this.targetObject != null && this.targetObject.getClass().isArray()) {
            int length = Array.getLength(this.targetObject);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(this.targetObject, i));
            }
            iterator = list.iterator();
        }
        if (iterator != null) {
            return PROXY_CONVERTER.toV8Value(this.v8Runtime, new V8VirtualIterator(iterator));
        }
        return this.v8Runtime.createV8ValueUndefined();
    }
}

