/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.webapi.core;

import com.capgemini.mrchecker.test.core.BaseTest;
import com.capgemini.mrchecker.test.core.ModuleType;
import com.capgemini.mrchecker.test.core.Page;
import com.capgemini.mrchecker.test.core.analytics.IAnalytics;
import com.capgemini.mrchecker.test.core.base.properties.PropertiesSettingsModule;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.capgemini.mrchecker.webapi.core.IWebAPI;
import com.capgemini.mrchecker.webapi.core.base.driver.DriverManager;
import com.capgemini.mrchecker.webapi.core.base.properties.PropertiesWebAPI;
import com.capgemini.mrchecker.webapi.core.base.runtime.RuntimeParameters;
import com.google.inject.Guice;
import com.google.inject.Module;
import io.restassured.config.RestAssuredConfig;
import io.restassured.specification.RequestSpecification;
import java.util.Arrays;
import java.util.Objects;

public abstract class BaseEndpoint
extends Page
implements IWebAPI {
    private static DriverManager driver = null;
    private static final PropertiesWebAPI PROPERTIES_WEB_API;
    private static final IAnalytics ANALYTICS;
    public static final String ANALYTICS_CATEGORY_NAME = "WebAPI-Module";

    public BaseEndpoint() {
        this.verifyStaticObject(PROPERTIES_WEB_API.getAllowStaticEndpoint(), "Endpoint");
    }

    public static IAnalytics getAnalytics() {
        return ANALYTICS;
    }

    public ModuleType getModuleType() {
        return ModuleType.WEBAPI;
    }

    public static RequestSpecification getDriver() {
        if (Objects.isNull(driver)) {
            driver = new DriverManager(PROPERTIES_WEB_API);
        }
        return driver.getDriverWebAPI();
    }

    public static RequestSpecification getDriver(RestAssuredConfig config) {
        if (Objects.isNull(driver)) {
            driver = new DriverManager(PROPERTIES_WEB_API);
        }
        return DriverManager.getDriverWebAPI(config);
    }

    private static PropertiesWebAPI setPropertiesSettings() {
        return (PropertiesWebAPI)Guice.createInjector((Module[])new Module[]{PropertiesSettingsModule.init()}).getInstance(PropertiesWebAPI.class);
    }

    private static void setRuntimeParametersWebApi() {
        BFLogger.logDebug((String)Arrays.asList(RuntimeParameters.values()).toString());
    }

    private static void setEnvironmentInstance() {
    }

    static {
        ANALYTICS = BaseTest.getAnalytics();
        PROPERTIES_WEB_API = BaseEndpoint.setPropertiesSettings();
        BaseEndpoint.setRuntimeParametersWebApi();
        BaseEndpoint.setEnvironmentInstance();
    }
}

