/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.webapi.core.base.driver;

import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.capgemini.mrchecker.webapi.core.base.driver.VirtualizedService;
import com.capgemini.mrchecker.webapi.core.base.driver.WireMockServerMrChecker;
import com.capgemini.mrchecker.webapi.core.base.properties.PropertiesWebAPI;
import com.capgemini.mrchecker.webapi.core.base.runtime.RuntimeParameters;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.opentable.extension.BodyTransformer;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Objects;

public class DriverManager {
    private static final ThreadLocal<VirtualizedService> driverVirtualizedService = new ThreadLocal();
    private static PropertiesWebAPI propertiesFileSettings;

    @Inject
    public DriverManager(@Named(value="properties") PropertiesWebAPI propertiesFileSettings) {
        if (Objects.isNull(DriverManager.propertiesFileSettings)) {
            DriverManager.propertiesFileSettings = propertiesFileSettings;
        }
    }

    public void start() {
        if (propertiesFileSettings.isVirtualServerEnabled()) {
            DriverManager.getDriverVirtualService();
        }
        DriverManager.getDriverWebAPI();
    }

    public void stop() {
        try {
            DriverManager.closeDriverVirtualServer();
            BFLogger.logDebug((String)"Closing Driver in stop()");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }

    public static void clearAllDrivers() {
        driverVirtualizedService.remove();
    }

    public static WireMock getDriverVirtualService() {
        VirtualizedService virtualizedService = DriverManager.getVirtualizedService();
        WireMock driver = virtualizedService.getDriver();
        BFLogger.logDebug((String)("Driver for server: " + driver.toString()));
        return driver;
    }

    public static WireMockServer getDriverVirtualServerService() {
        VirtualizedService virtualizedService = DriverManager.getVirtualizedService();
        WireMockServer driver = virtualizedService.getDriverServer();
        BFLogger.logDebug((String)("Driver for virtual server: " + driver.toString()));
        return driver;
    }

    public static int getHttpPort() {
        VirtualizedService virtualizedService = DriverManager.getVirtualizedService();
        return virtualizedService.getHttpPort();
    }

    public static String getHttpHost() {
        VirtualizedService virtualizedService = DriverManager.getVirtualizedService();
        return virtualizedService.getHttpHost();
    }

    public static String getEndpointBaseUri() {
        VirtualizedService virtualizedService = DriverManager.getVirtualizedService();
        return virtualizedService.getEndpointBaseUri();
    }

    private static VirtualizedService getVirtualizedService() {
        VirtualizedService virtualizedService = driverVirtualizedService.get();
        if (Objects.isNull(virtualizedService)) {
            virtualizedService = DriverManager.createDriverVirtualServer();
            driverVirtualizedService.set(virtualizedService);
        }
        return virtualizedService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDriverVirtualServer() {
        VirtualizedService virtualizedService = driverVirtualizedService.get();
        if (!Objects.isNull(virtualizedService)) {
            WireMock driver = virtualizedService.getDriver();
            WireMockServer driverServer = virtualizedService.getDriverServer();
            BFLogger.logDebug((String)("Closing communication to Virualize Service under: " + driver.toString()));
            try {
                if (!Objects.isNull(driver)) {
                    // empty if block
                }
                if (!Objects.isNull(driverServer)) {
                    driverServer.stop();
                }
            }
            catch (Exception e) {
                BFLogger.logDebug((String)"Ooops! Something went wrong while closing the driver");
            }
            finally {
                DriverManager.clearAllDrivers();
            }
        }
    }

    static VirtualizedService createDriverVirtualServer() {
        BFLogger.logDebug((String)"Creating new Mock Server");
        VirtualizedService virtualizedService = Driver.WIREMOCK.getDriver();
        BFLogger.logDebug((String)("Running: " + virtualizedService.toString()));
        return virtualizedService;
    }

    public static RequestSpecification getDriverWebAPI() {
        RestAssuredConfig config = new RestAssuredConfig().encoderConfig(new EncoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false));
        return DriverManager.getDriverWebAPI(config);
    }

    public static RequestSpecification getDriverWebAPI(RestAssuredConfig config) {
        RequestSpecification driver = DriverManager.createDriverWebAPI(config);
        BFLogger.logDebug((String)("driver:" + driver.toString()));
        return driver;
    }

    private static RequestSpecification createDriverWebAPI(RestAssuredConfig config) {
        BFLogger.logDebug((String)"Creating new driver.");
        RestAssured.config = config;
        return RestAssured.given();
    }

    private static enum Driver {
        WIREMOCK{

            @Override
            public VirtualizedService getDriver() throws FatalStartupException {
                WireMock driver;
                WireMockServerMrChecker driverServer = null;
                int httpPort = this.getPort();
                String httpHost = this.getHost();
                if ("".equals(httpHost) || "http://localhost".equals(httpHost) || "https://localhost".equals(httpHost)) {
                    WireMockConfiguration wireMockConfig = WireMockConfiguration.wireMockConfig().extensions(new Extension[]{new BodyTransformer()});
                    wireMockConfig.port(httpPort);
                    driverServer = new WireMockServerMrChecker((Options)wireMockConfig);
                    try {
                        driverServer.start();
                    }
                    catch (FatalStartupException e) {
                        BFLogger.logError((String)(e.getMessage() + "host " + httpHost + ":" + httpPort));
                        throw new FatalStartupException((Throwable)e);
                    }
                    driver = driverServer.getClient();
                } else {
                    driver = new WireMock(httpHost, httpPort);
                    driver.startStubRecording("http://example.mocklab.io");
                    driver.stopStubRecording();
                }
                return new VirtualizedService(driver, driverServer, httpHost, httpPort);
            }

            private String getHost() {
                return RuntimeParameters.MOCK_HTTP_HOST.getValue();
            }

            private int getPort() {
                return RuntimeParameters.MOCK_HTTP_PORT.getValue().isEmpty() ? this.findFreePort() : this.getInteger(RuntimeParameters.MOCK_HTTP_PORT.getValue());
            }

            private int findFreePort() throws IllegalStateException {
                int n;
                ServerSocket socket = new ServerSocket(0);
                try {
                    socket.setReuseAddress(true);
                    int port = socket.getLocalPort();
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    n = port;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("Could not find a free TCP/IP port to start embedded Jetty HTTP Server on");
                    }
                }
                socket.close();
                return n;
            }

            private int getInteger(String value) {
                int number = 0;
                try {
                    number = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    BFLogger.logError((String)("Unable convert to integer value=" + value + " Setting default value=0"));
                }
                return number;
            }
        };


        public VirtualizedService getDriver() {
            return null;
        }
    }
}

