/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.AbstractMavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class InvokerMavenExecutor
extends AbstractMavenExecutor {
    private static final Options OPTIONS = new Options();
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char OFFLINE = 'o';
    private static final char REACTOR = 'r';
    private static final char QUIET = 'q';
    private static final char DEBUG = 'X';
    private static final char ERRORS = 'e';
    private static final char NON_RECURSIVE = 'N';
    private static final char UPDATE_SNAPSHOTS = 'U';
    private static final char ACTIVATE_PROFILES = 'P';
    private static final String FORCE_PLUGIN_UPDATES = "cpu";
    private static final String FORCE_PLUGIN_UPDATES2 = "up";
    private static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    private static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    private static final char CHECKSUM_FAILURE_POLICY = 'C';
    private static final char CHECKSUM_WARNING_POLICY = 'c';
    private static final char ALTERNATE_USER_SETTINGS = 's';
    private static final String FAIL_FAST = "ff";
    private static final String FAIL_AT_END = "fae";
    private static final String FAIL_NEVER = "fn";

    private void setupRequest(InvocationRequest req, LoggerBridge bridge, String additionalArguments) throws MavenExecutorException {
        try {
            String[] args = CommandLineUtils.translateCommandline((String)additionalArguments);
            CommandLine cli = new PosixParser().parse(OPTIONS, args);
            if (cli.hasOption('D')) {
                String[] properties = cli.getOptionValues('D');
                Properties props = new Properties();
                for (int i = 0; i < properties.length; ++i) {
                    String value;
                    String name;
                    String property = properties[i];
                    int sep = property.indexOf("=");
                    if (sep <= 0) {
                        name = property.trim();
                        value = "true";
                    } else {
                        name = property.substring(0, sep).trim();
                        value = property.substring(sep + 1).trim();
                    }
                    props.setProperty(name, value);
                }
                req.setProperties(props);
            }
            if (cli.hasOption('o')) {
                req.setOffline(true);
            }
            if (cli.hasOption('q')) {
                bridge.setThreshold(3);
            } else if (cli.hasOption('X')) {
                req.setDebug(true);
            } else if (cli.hasOption('e')) {
                req.setShowErrors(true);
            }
            if (cli.hasOption('r')) {
                req.setRecursive(true);
            } else if (cli.hasOption('N')) {
                req.setRecursive(false);
            }
            if (cli.hasOption('U')) {
                req.setUpdateSnapshots(true);
            }
            if (cli.hasOption('P')) {
                String[] profiles = cli.getOptionValues('P');
                ArrayList<String> activatedProfiles = new ArrayList<String>();
                ArrayList<String> deactivatedProfiles = new ArrayList<String>();
                if (profiles != null) {
                    for (int i = 0; i < profiles.length; ++i) {
                        StringTokenizer profileTokens = new StringTokenizer(profiles[i], ",");
                        while (profileTokens.hasMoreTokens()) {
                            String profileAction = profileTokens.nextToken().trim();
                            if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                                deactivatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            if (profileAction.startsWith("+")) {
                                activatedProfiles.add(profileAction.substring(1));
                                continue;
                            }
                            activatedProfiles.add(profileAction);
                        }
                    }
                }
                if (!deactivatedProfiles.isEmpty()) {
                    this.getLogger().warn("Explicit profile deactivation is not yet supported. The following profiles will NOT be deactivated: " + StringUtils.join(deactivatedProfiles.iterator(), (String)", "));
                }
                if (!activatedProfiles.isEmpty()) {
                    req.setProfiles(activatedProfiles);
                }
            }
            if (cli.hasOption(FORCE_PLUGIN_UPDATES) || cli.hasOption(FORCE_PLUGIN_UPDATES2)) {
                this.getLogger().warn("Forcing plugin updates is not supported currently.");
            } else if (cli.hasOption(SUPPRESS_PLUGIN_UPDATES)) {
                req.setNonPluginUpdates(true);
            }
            if (cli.hasOption(SUPPRESS_PLUGIN_REGISTRY)) {
                this.getLogger().warn("Explicit suppression of the plugin registry is not supported currently.");
            }
            if (cli.hasOption('C')) {
                req.setGlobalChecksumPolicy("fail");
            } else if (cli.hasOption('c')) {
                req.setGlobalChecksumPolicy("warn");
            }
            if (cli.hasOption('s')) {
                req.setUserSettingsFile(new File(cli.getOptionValue('s')));
            }
            if (cli.hasOption(FAIL_AT_END)) {
                req.setFailureBehavior("fail-at-end");
            } else if (cli.hasOption(FAIL_FAST)) {
                req.setFailureBehavior("fail-fast");
            }
            if (cli.hasOption(FAIL_NEVER)) {
                req.setFailureBehavior("fail-never");
            }
        }
        catch (Exception e) {
            throw new MavenExecutorException("Failed to re-parse additional arguments for Maven invocation.", e);
        }
    }

    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        File localRepoDir;
        Handler handler = new Handler(this.getLogger());
        LoggerBridge bridge = new LoggerBridge(this.getLogger());
        Invoker invoker = new DefaultInvoker().setMavenHome(releaseEnvironment.getMavenHome()).setLogger((InvokerLogger)bridge).setOutputHandler((InvocationOutputHandler)handler).setErrorHandler((InvocationOutputHandler)handler);
        InvocationRequest req = new DefaultInvocationRequest().setDebug(this.getLogger().isDebugEnabled()).setBaseDirectory(workingDirectory).setInteractive(interactive);
        if (pomFileName != null) {
            req.setPomFileName(pomFileName);
        }
        if (releaseEnvironment.getSettings() != null) {
            req.setUserSettingsFile(releaseEnvironment.getSettings().getRuntimeInfo().getFile());
        }
        if ((localRepoDir = releaseEnvironment.getLocalRepositoryDirectory()) != null) {
            req.setLocalRepositoryDirectory(localRepoDir);
        }
        this.setupRequest(req, bridge, additionalArguments);
        if (goals.trim().length() > 0) {
            String[] rawGoals = goals.split(" ");
            req.setGoals(Arrays.asList(rawGoals));
        }
        try {
            InvocationResult invocationResult = invoker.execute(req);
            if (invocationResult.getExecutionException() != null) {
                throw new MavenExecutorException("Error executing Maven.", invocationResult.getExecutionException());
            }
            if (invocationResult.getExitCode() != 0) {
                throw new MavenExecutorException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'", invocationResult.getExitCode(), "", "");
            }
        }
        catch (MavenInvocationException e) {
            throw new MavenExecutorException("Failed to invoke Maven build.", e);
        }
    }

    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, releaseEnvironment, interactive, additionalArguments, null, result);
    }

    static {
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define a system property");
        OPTIONS.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"offline");
        OptionBuilder.withDescription((String)"Work offline");
        OPTIONS.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)"Quiet output - only show errors");
        OPTIONS.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"Produce execution debug output");
        OPTIONS.addOption(OptionBuilder.create((char)'X'));
        OptionBuilder.withLongOpt((String)"errors");
        OptionBuilder.withDescription((String)"Produce execution error messages");
        OPTIONS.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"reactor");
        OptionBuilder.withDescription((String)"Execute goals for project found in the reactor");
        OPTIONS.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"non-recursive");
        OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
        OPTIONS.addOption(OptionBuilder.create((char)'N'));
        OptionBuilder.withLongOpt((String)"update-snapshots");
        OptionBuilder.withDescription((String)"Forces a check for updated releases and snapshots on remote repositories");
        OPTIONS.addOption(OptionBuilder.create((char)'U'));
        OptionBuilder.withLongOpt((String)"activate-profiles");
        OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"check-plugin-updates");
        OptionBuilder.withDescription((String)"Force upToDate check for any relevant registered plugins");
        OPTIONS.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt((String)"update-plugins");
        OptionBuilder.withDescription((String)"Synonym for cpu");
        OPTIONS.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES2));
        OptionBuilder.withLongOpt((String)"no-plugin-updates");
        OptionBuilder.withDescription((String)"Suppress upToDate check for any relevant registered plugins");
        OPTIONS.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt((String)"no-plugin-registry");
        OptionBuilder.withDescription((String)"Don't use ~/.m2/plugin-registry.xml for plugin versions");
        OPTIONS.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_REGISTRY));
        OptionBuilder.withLongOpt((String)"strict-checksums");
        OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
        OPTIONS.addOption(OptionBuilder.create((char)'C'));
        OptionBuilder.withLongOpt((String)"lax-checksums");
        OptionBuilder.withDescription((String)"Warn if checksums don't match");
        OPTIONS.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"settings");
        OptionBuilder.withDescription((String)"Alternate path for the user settings file");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"fail-fast");
        OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
        OPTIONS.addOption(OptionBuilder.create((String)FAIL_FAST));
        OptionBuilder.withLongOpt((String)"fail-at-end");
        OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
        OPTIONS.addOption(OptionBuilder.create((String)FAIL_AT_END));
        OptionBuilder.withLongOpt((String)"fail-never");
        OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
        OPTIONS.addOption(OptionBuilder.create((String)FAIL_NEVER));
    }

    private static final class LoggerBridge
    implements InvokerLogger {
        private Logger logger;

        LoggerBridge(Logger logger) {
            this.logger = logger;
        }

        public void debug(String message, Throwable error) {
            this.logger.debug(message, error);
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void error(String message, Throwable error) {
            this.logger.error(message, error);
        }

        public void error(String message) {
            this.logger.error(message);
        }

        public void fatalError(String message, Throwable error) {
            this.logger.fatalError(message, error);
        }

        public void fatalError(String message) {
            this.logger.fatalError(message);
        }

        public Logger getChildLogger(String message) {
            return this.logger.getChildLogger(message);
        }

        public String getName() {
            return this.logger.getName();
        }

        public int getThreshold() {
            return this.logger.getThreshold();
        }

        public void info(String message, Throwable error) {
            this.logger.info(message, error);
        }

        public void info(String message) {
            this.logger.info(message);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return this.logger.isFatalErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void setThreshold(int level) {
            this.logger.setThreshold(level);
        }

        public void warn(String message, Throwable error) {
            this.logger.warn(message, error);
        }

        public void warn(String message) {
            this.logger.warn(message);
        }
    }

    private static final class Handler
    implements InvocationOutputHandler {
        private Logger logger;

        Handler(Logger logger) {
            this.logger = logger;
        }

        public void consumeLine(String line) {
            this.logger.info(line);
        }
    }
}

