/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws;

import com.carepay.aws.auth.AWS4Signer;
import com.carepay.aws.net.MockHttpURLConnection;
import com.carepay.aws.net.RequestWriter;
import com.carepay.aws.net.ResponseReader;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.net.WebClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class AWSClient
extends WebClient {
    protected final AWS4Signer signer;
    protected static final SAXParser SAX_PARSER;

    public AWSClient(AWS4Signer signer, URLOpener opener) {
        super(opener);
        this.signer = signer;
    }

    public <T> T signedExecute(String method, URL url, RequestWriter requestWriter, ResponseReader<T> reader, Map<String, String> headers) throws IOException {
        return super.execute(method, url, new SigningRequestWriter(requestWriter, this.signer), reader, headers);
    }

    protected String getRegion() {
        return this.signer.getRegionProvider().getRegion();
    }

    static {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAX_PARSER = factory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static class SigningRequestWriter
    implements RequestWriter {
        private final RequestWriter requestWriter;
        private final AWS4Signer signer;

        public SigningRequestWriter(RequestWriter requestWriter, AWS4Signer signer) {
            this.requestWriter = requestWriter;
            this.signer = signer;
        }

        @Override
        public void write(HttpURLConnection uc) throws IOException {
            if (this.requestWriter != null) {
                MockHttpURLConnection mockHttpURLConnection = new MockHttpURLConnection(uc.getURL());
                this.requestWriter.write(mockHttpURLConnection);
                byte[] bytes = mockHttpURLConnection.getBytes();
                this.signer.signHeaders(uc, bytes);
                uc.getOutputStream().write(bytes);
            } else {
                this.signer.signHeaders(uc, null);
            }
        }
    }
}

